@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.inputs

import com.pulumi.aws.verifiedpermissions.inputs.PolicyStoreValidationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode The mode for the validation settings. Valid values: `OFF`, `STRICT`.
 * The following arguments are optional:
 */
public data class PolicyStoreValidationSettingsArgs(
    public val mode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.verifiedpermissions.inputs.PolicyStoreValidationSettingsArgs> {
    override fun toJava(): com.pulumi.aws.verifiedpermissions.inputs.PolicyStoreValidationSettingsArgs = com.pulumi.aws.verifiedpermissions.inputs.PolicyStoreValidationSettingsArgs.builder()
        .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyStoreValidationSettingsArgs].
 */
@PulumiTagMarker
public class PolicyStoreValidationSettingsArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value The mode for the validation settings. Valid values: `OFF`, `STRICT`.
     * The following arguments are optional:
     */
    @JvmName("ksxjhnnqunwmwlfp")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The mode for the validation settings. Valid values: `OFF`, `STRICT`.
     * The following arguments are optional:
     */
    @JvmName("pheukkgymnquifyn")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): PolicyStoreValidationSettingsArgs = PolicyStoreValidationSettingsArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
