@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicyStore.
 * @property arn The ARN of the Policy Store.
 * @property createdDate The date the Policy Store was created.
 * @property description
 * @property id
 * @property lastUpdatedDate The date the Policy Store was last updated.
 * @property validationSettings Validation settings for the policy store.
 */
public data class GetPolicyStoreResult(
    public val arn: String,
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val lastUpdatedDate: String,
    public val validationSettings: List<GetPolicyStoreValidationSetting>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.GetPolicyStoreResult): GetPolicyStoreResult = GetPolicyStoreResult(
            arn = javaType.arn(),
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            id = javaType.id(),
            lastUpdatedDate = javaType.lastUpdatedDate(),
            validationSettings = javaType.validationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedpermissions.kotlin.outputs.GetPolicyStoreValidationSetting.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
