@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cognitoUserPoolConfiguration Specifies the configuration details of an Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. See Cognito User Pool Configuration below.
 * @property openIdConnectConfiguration Specifies the configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. See Open ID Connect Configuration below.
 */
public data class IdentitySourceConfiguration(
    public val cognitoUserPoolConfiguration: IdentitySourceConfigurationCognitoUserPoolConfiguration? =
        null,
    public val openIdConnectConfiguration: IdentitySourceConfigurationOpenIdConnectConfiguration? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.IdentitySourceConfiguration): IdentitySourceConfiguration = IdentitySourceConfiguration(
            cognitoUserPoolConfiguration = javaType.cognitoUserPoolConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedpermissions.kotlin.outputs.IdentitySourceConfigurationCognitoUserPoolConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            openIdConnectConfiguration = javaType.openIdConnectConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedpermissions.kotlin.outputs.IdentitySourceConfigurationOpenIdConnectConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
