@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clientIds The unique application client IDs that are associated with the specified Amazon Cognito user pool.
 * @property groupConfiguration The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
 * @property userPoolArn The Amazon Resource Name (ARN) of the Amazon Cognito user pool that contains the identities to be authorized.
 */
public data class IdentitySourceConfigurationCognitoUserPoolConfiguration(
    public val clientIds: List<String>? = null,
    public val groupConfiguration: IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration? = null,
    public val userPoolArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.IdentitySourceConfigurationCognitoUserPoolConfiguration): IdentitySourceConfigurationCognitoUserPoolConfiguration =
            IdentitySourceConfigurationCognitoUserPoolConfiguration(
                clientIds = javaType.clientIds().map({ args0 -> args0 }),
                groupConfiguration = javaType.groupConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.verifiedpermissions.kotlin.outputs.IdentitySourceConfigurationCognitoUserPoolConfigurationGroupConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                userPoolArn = javaType.userPoolArn(),
            )
    }
}
