@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property entityIdPrefix A descriptive string that you want to prefix to user entities from your OIDC identity provider.
 * @property groupConfiguration The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source. See Group Configuration below.
 * @property issuer The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
 * @property tokenSelection The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source. See Token Selection below.
 */
public data class IdentitySourceConfigurationOpenIdConnectConfiguration(
    public val entityIdPrefix: String? = null,
    public val groupConfiguration: IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration? = null,
    public val issuer: String,
    public val tokenSelection: IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.IdentitySourceConfigurationOpenIdConnectConfiguration): IdentitySourceConfigurationOpenIdConnectConfiguration =
            IdentitySourceConfigurationOpenIdConnectConfiguration(
                entityIdPrefix = javaType.entityIdPrefix().map({ args0 -> args0 }).orElse(null),
                groupConfiguration = javaType.groupConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.verifiedpermissions.kotlin.outputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                issuer = javaType.issuer(),
                tokenSelection = javaType.tokenSelection().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.verifiedpermissions.kotlin.outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
