@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupClaim The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
 * @property groupEntityType The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
 */
public data class IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration(
    public val groupClaim: String,
    public val groupEntityType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration): IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration =
            IdentitySourceConfigurationOpenIdConnectConfigurationGroupConfiguration(
                groupClaim = javaType.groupClaim(),
                groupEntityType = javaType.groupEntityType(),
            )
    }
}
