@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property accessTokenOnly The OIDC configuration for processing access tokens. See Access Token Only below.
 * @property identityTokenOnly The OIDC configuration for processing identity (ID) tokens. See Identity Token Only below.
 */
public data class IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection(
    public val accessTokenOnly: IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly? = null,
    public val identityTokenOnly: IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection): IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection =
            IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelection(
                accessTokenOnly = javaType.accessTokenOnly().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.verifiedpermissions.kotlin.outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionAccessTokenOnly.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                identityTokenOnly = javaType.identityTokenOnly().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.verifiedpermissions.kotlin.outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
