@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clientIds The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
 * @property principalIdClaim The claim that determines the principal in OIDC access tokens.
 */
public data class
IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly(
    public val clientIds: List<String>? = null,
    public val principalIdClaim: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly): IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly =
            IdentitySourceConfigurationOpenIdConnectConfigurationTokenSelectionIdentityTokenOnly(
                clientIds = javaType.clientIds().map({ args0 -> args0 }),
                principalIdClaim = javaType.principalIdClaim().map({ args0 -> args0 }).orElse(null),
            )
    }
}
