@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property static The static policy statement. See Static below.
 * @property templateLinked The template linked policy. See Template Linked below.
 */
public data class PolicyDefinition(
    public val static: PolicyDefinitionStatic? = null,
    public val templateLinked: PolicyDefinitionTemplateLinked? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.PolicyDefinition): PolicyDefinition = PolicyDefinition(
            static = javaType.static_().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedpermissions.kotlin.outputs.PolicyDefinitionStatic.Companion.toKotlin(args0)
                })
            }).orElse(null),
            templateLinked = javaType.templateLinked().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedpermissions.kotlin.outputs.PolicyDefinitionTemplateLinked.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
