@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the static policy.
 * @property statement The statement of the static policy.
 */
public data class PolicyDefinitionStatic(
    public val description: String? = null,
    public val statement: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.PolicyDefinitionStatic): PolicyDefinitionStatic = PolicyDefinitionStatic(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            statement = javaType.statement(),
        )
    }
}
