@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedpermissions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property policyTemplateId The ID of the template.
 * @property principal The principal of the template linked policy.
 * @property resource The resource of the template linked policy.
 */
public data class PolicyDefinitionTemplateLinked(
    public val policyTemplateId: String,
    public val principal: PolicyDefinitionTemplateLinkedPrincipal? = null,
    public val resource: PolicyDefinitionTemplateLinkedResource? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedpermissions.outputs.PolicyDefinitionTemplateLinked): PolicyDefinitionTemplateLinked = PolicyDefinitionTemplateLinked(
            policyTemplateId = javaType.policyTemplateId(),
            principal = javaType.principal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedpermissions.kotlin.outputs.PolicyDefinitionTemplateLinkedPrincipal.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resource = javaType.resource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedpermissions.kotlin.outputs.PolicyDefinitionTemplateLinkedResource.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
