@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EndpointPrivateDns].
 */
@PulumiTagMarker
public class EndpointPrivateDnsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointPrivateDnsArgs = EndpointPrivateDnsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointPrivateDnsArgsBuilder.() -> Unit) {
        val builder = EndpointPrivateDnsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointPrivateDns {
        val builtJavaResource = com.pulumi.aws.vpc.EndpointPrivateDns(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointPrivateDns(builtJavaResource)
    }
}

/**
 * Resource for enabling private DNS on an AWS VPC (Virtual Private Cloud) Endpoint.
 * > When using this resource, the `private_dns_enabled` argument should be omitted on the parent `aws.ec2.VpcEndpoint` resource.
 * Setting the value both places can lead to unintended behavior and persistent differences.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpc.EndpointPrivateDns("example", {
 *     vpcEndpointId: exampleAwsVpcEndpoint.id,
 *     privateDnsEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpc.EndpointPrivateDns("example",
 *     vpc_endpoint_id=example_aws_vpc_endpoint["id"],
 *     private_dns_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Vpc.EndpointPrivateDns("example", new()
 *     {
 *         VpcEndpointId = exampleAwsVpcEndpoint.Id,
 *         PrivateDnsEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpc.NewEndpointPrivateDns(ctx, "example", &vpc.EndpointPrivateDnsArgs{
 * 			VpcEndpointId:     pulumi.Any(exampleAwsVpcEndpoint.Id),
 * 			PrivateDnsEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpc.EndpointPrivateDns;
 * import com.pulumi.aws.vpc.EndpointPrivateDnsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointPrivateDns("example", EndpointPrivateDnsArgs.builder()
 *             .vpcEndpointId(exampleAwsVpcEndpoint.id())
 *             .privateDnsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpc:EndpointPrivateDns
 *     properties:
 *       vpcEndpointId: ${exampleAwsVpcEndpoint.id}
 *       privateDnsEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a VPC (Virtual Private Cloud) Endpoint Private DNS using the `vpc_endpoint_id`. For example:
 * ```sh
 * $ pulumi import aws:vpc/endpointPrivateDns:EndpointPrivateDns example vpce-abcd-1234
 * ```
 */
public class EndpointPrivateDns internal constructor(
    override val javaResource: com.pulumi.aws.vpc.EndpointPrivateDns,
) : KotlinCustomResource(javaResource, EndpointPrivateDnsMapper) {
    /**
     * Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
     */
    public val privateDnsEnabled: Output<Boolean>
        get() = javaResource.privateDnsEnabled().applyValue({ args0 -> args0 })

    /**
     * VPC endpoint identifier.
     */
    public val vpcEndpointId: Output<String>
        get() = javaResource.vpcEndpointId().applyValue({ args0 -> args0 })
}

public object EndpointPrivateDnsMapper : ResourceMapper<EndpointPrivateDns> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpc.EndpointPrivateDns::class == javaResource::class

    override fun map(javaResource: Resource): EndpointPrivateDns = EndpointPrivateDns(
        javaResource as
            com.pulumi.aws.vpc.EndpointPrivateDns,
    )
}

/**
 * @see [EndpointPrivateDns].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointPrivateDns].
 */
public suspend fun endpointPrivateDns(
    name: String,
    block: suspend EndpointPrivateDnsResourceBuilder.() -> Unit,
): EndpointPrivateDns {
    val builder = EndpointPrivateDnsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointPrivateDns].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointPrivateDns(name: String): EndpointPrivateDns {
    val builder = EndpointPrivateDnsResourceBuilder()
    builder.name(name)
    return builder.build()
}
