@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.aws.vpc.EndpointPrivateDnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for enabling private DNS on an AWS VPC (Virtual Private Cloud) Endpoint.
 * > When using this resource, the `private_dns_enabled` argument should be omitted on the parent `aws.ec2.VpcEndpoint` resource.
 * Setting the value both places can lead to unintended behavior and persistent differences.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpc.EndpointPrivateDns("example", {
 *     vpcEndpointId: exampleAwsVpcEndpoint.id,
 *     privateDnsEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpc.EndpointPrivateDns("example",
 *     vpc_endpoint_id=example_aws_vpc_endpoint["id"],
 *     private_dns_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Vpc.EndpointPrivateDns("example", new()
 *     {
 *         VpcEndpointId = exampleAwsVpcEndpoint.Id,
 *         PrivateDnsEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpc.NewEndpointPrivateDns(ctx, "example", &vpc.EndpointPrivateDnsArgs{
 * 			VpcEndpointId:     pulumi.Any(exampleAwsVpcEndpoint.Id),
 * 			PrivateDnsEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpc.EndpointPrivateDns;
 * import com.pulumi.aws.vpc.EndpointPrivateDnsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointPrivateDns("example", EndpointPrivateDnsArgs.builder()
 *             .vpcEndpointId(exampleAwsVpcEndpoint.id())
 *             .privateDnsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpc:EndpointPrivateDns
 *     properties:
 *       vpcEndpointId: ${exampleAwsVpcEndpoint.id}
 *       privateDnsEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a VPC (Virtual Private Cloud) Endpoint Private DNS using the `vpc_endpoint_id`. For example:
 * ```sh
 * $ pulumi import aws:vpc/endpointPrivateDns:EndpointPrivateDns example vpce-abcd-1234
 * ```
 * @property privateDnsEnabled Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
 * @property vpcEndpointId VPC endpoint identifier.
 */
public data class EndpointPrivateDnsArgs(
    public val privateDnsEnabled: Output<Boolean>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpc.EndpointPrivateDnsArgs> {
    override fun toJava(): com.pulumi.aws.vpc.EndpointPrivateDnsArgs =
        com.pulumi.aws.vpc.EndpointPrivateDnsArgs.builder()
            .privateDnsEnabled(privateDnsEnabled?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointPrivateDnsArgs].
 */
@PulumiTagMarker
public class EndpointPrivateDnsArgsBuilder internal constructor() {
    private var privateDnsEnabled: Output<Boolean>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
     */
    @JvmName("nbkqhtebkfxlykbi")
    public suspend fun privateDnsEnabled(`value`: Output<Boolean>) {
        this.privateDnsEnabled = value
    }

    /**
     * @param value VPC endpoint identifier.
     */
    @JvmName("ddiohfssaqgydbyq")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value Indicates whether a private hosted zone is associated with the VPC. Only applicable for `Interface` endpoints.
     */
    @JvmName("dsykjfspnwdfajfx")
    public suspend fun privateDnsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsEnabled = mapped
    }

    /**
     * @param value VPC endpoint identifier.
     */
    @JvmName("vwipnphosrgypuqk")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): EndpointPrivateDnsArgs = EndpointPrivateDnsArgs(
        privateDnsEnabled = privateDnsEnabled,
        vpcEndpointId = vpcEndpointId,
    )
}
