@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an outbound (egress) rule for a security group.
 * When specifying an outbound rule for your security group in a VPC, the configuration must include a destination for the traffic.
 * > **NOTE:** Using `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources is the current best practice. Avoid using the `aws.ec2.SecurityGroupRule` resource and the `ingress` and `egress` arguments of the `aws.ec2.SecurityGroup` resource for configuring in-line rules, as they struggle with managing multiple CIDR blocks, and tags and descriptions due to the historical lack of unique IDs.
 * !> **WARNING:** You should not use the `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources in conjunction with the `aws.ec2.SecurityGroup` resource with _in-line rules_ (using the `ingress` and `egress` arguments of `aws.ec2.SecurityGroup`) or the `aws.ec2.SecurityGroupRule` resource. Doing so may cause rule conflicts, perpetual differences, and result in rules being overwritten.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpc.SecurityGroupEgressRule("example", {
 *     securityGroupId: exampleAwsSecurityGroup.id,
 *     cidrIpv4: "10.0.0.0/8",
 *     fromPort: 80,
 *     ipProtocol: "tcp",
 *     toPort: 80,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpc.SecurityGroupEgressRule("example",
 *     security_group_id=example_aws_security_group["id"],
 *     cidr_ipv4="10.0.0.0/8",
 *     from_port=80,
 *     ip_protocol="tcp",
 *     to_port=80)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Vpc.SecurityGroupEgressRule("example", new()
 *     {
 *         SecurityGroupId = exampleAwsSecurityGroup.Id,
 *         CidrIpv4 = "10.0.0.0/8",
 *         FromPort = 80,
 *         IpProtocol = "tcp",
 *         ToPort = 80,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpc.NewSecurityGroupEgressRule(ctx, "example", &vpc.SecurityGroupEgressRuleArgs{
 * 			SecurityGroupId: pulumi.Any(exampleAwsSecurityGroup.Id),
 * 			CidrIpv4:        pulumi.String("10.0.0.0/8"),
 * 			FromPort:        pulumi.Int(80),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			ToPort:          pulumi.Int(80),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpc.SecurityGroupEgressRule;
 * import com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroupEgressRule("example", SecurityGroupEgressRuleArgs.builder()
 *             .securityGroupId(exampleAwsSecurityGroup.id())
 *             .cidrIpv4("10.0.0.0/8")
 *             .fromPort(80)
 *             .ipProtocol("tcp")
 *             .toPort(80)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpc:SecurityGroupEgressRule
 *     properties:
 *       securityGroupId: ${exampleAwsSecurityGroup.id}
 *       cidrIpv4: 10.0.0.0/8
 *       fromPort: 80
 *       ipProtocol: tcp
 *       toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import security group egress rules using the `security_group_rule_id`. For example:
 * ```sh
 * $ pulumi import aws:vpc/securityGroupEgressRule:SecurityGroupEgressRule example sgr-02108b27edd666983
 * ```
 * @property cidrIpv4 The destination IPv4 CIDR range.
 * @property cidrIpv6 The destination IPv6 CIDR range.
 * @property description The security group rule description.
 * @property fromPort The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
 * @property ipProtocol The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
 * @property prefixListId The ID of the destination prefix list.
 * @property referencedSecurityGroupId The destination security group that is referenced in the rule.
 * @property securityGroupId The ID of the security group.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property toPort The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
 */
public data class SecurityGroupEgressRuleArgs(
    public val cidrIpv4: Output<String>? = null,
    public val cidrIpv6: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fromPort: Output<Int>? = null,
    public val ipProtocol: Output<String>? = null,
    public val prefixListId: Output<String>? = null,
    public val referencedSecurityGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs> {
    override fun toJava(): com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs =
        com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs.builder()
            .cidrIpv4(cidrIpv4?.applyValue({ args0 -> args0 }))
            .cidrIpv6(cidrIpv6?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .prefixListId(prefixListId?.applyValue({ args0 -> args0 }))
            .referencedSecurityGroupId(referencedSecurityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupEgressRuleArgs].
 */
@PulumiTagMarker
public class SecurityGroupEgressRuleArgsBuilder internal constructor() {
    private var cidrIpv4: Output<String>? = null

    private var cidrIpv6: Output<String>? = null

    private var description: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var ipProtocol: Output<String>? = null

    private var prefixListId: Output<String>? = null

    private var referencedSecurityGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The destination IPv4 CIDR range.
     */
    @JvmName("knxbdjexihiarqlq")
    public suspend fun cidrIpv4(`value`: Output<String>) {
        this.cidrIpv4 = value
    }

    /**
     * @param value The destination IPv6 CIDR range.
     */
    @JvmName("bndjnmfmrssmpymv")
    public suspend fun cidrIpv6(`value`: Output<String>) {
        this.cidrIpv6 = value
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("tpooakrfllgovphi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("vgnkbifqlqojhkfy")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("vrrcjfihwyufxfex")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The ID of the destination prefix list.
     */
    @JvmName("lpqwgjptvovoenxw")
    public suspend fun prefixListId(`value`: Output<String>) {
        this.prefixListId = value
    }

    /**
     * @param value The destination security group that is referenced in the rule.
     */
    @JvmName("cminjbphmdlkjtmg")
    public suspend fun referencedSecurityGroupId(`value`: Output<String>) {
        this.referencedSecurityGroupId = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("iwfmgyimcmaivdoq")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("balwdygijdssrggf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("ehharpqbfafsowxk")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The destination IPv4 CIDR range.
     */
    @JvmName("xrshuuskpowjvklh")
    public suspend fun cidrIpv4(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv4 = mapped
    }

    /**
     * @param value The destination IPv6 CIDR range.
     */
    @JvmName("yxcuhgwrcrryrlwt")
    public suspend fun cidrIpv6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv6 = mapped
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("mrdndvocxbemmrjh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("apggkpelfdxjyfcg")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("fkutmoapowiekycq")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The ID of the destination prefix list.
     */
    @JvmName("cwmadaqrgivvemmr")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListId = mapped
    }

    /**
     * @param value The destination security group that is referenced in the rule.
     */
    @JvmName("poiaykosdkprdmep")
    public suspend fun referencedSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referencedSecurityGroupId = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("mqcdjaflrfpdugbp")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("csgdlibpufyyjnnk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("udpqhddsfkbbtmsj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("gveyefaeqvgydohm")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): SecurityGroupEgressRuleArgs = SecurityGroupEgressRuleArgs(
        cidrIpv4 = cidrIpv4,
        cidrIpv6 = cidrIpv6,
        description = description,
        fromPort = fromPort,
        ipProtocol = ipProtocol,
        prefixListId = prefixListId,
        referencedSecurityGroupId = referencedSecurityGroupId,
        securityGroupId = securityGroupId,
        tags = tags,
        toPort = toPort,
    )
}
