@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SecurityGroupIngressRule].
 */
@PulumiTagMarker
public class SecurityGroupIngressRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityGroupIngressRuleArgs = SecurityGroupIngressRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityGroupIngressRuleArgsBuilder.() -> Unit) {
        val builder = SecurityGroupIngressRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityGroupIngressRule {
        val builtJavaResource = com.pulumi.aws.vpc.SecurityGroupIngressRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityGroupIngressRule(builtJavaResource)
    }
}

/**
 * Manages an inbound (ingress) rule for a security group.
 * When specifying an inbound rule for your security group in a VPC, the configuration must include a source for the traffic.
 * > **NOTE:** Using `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources is the current best practice. Avoid using the `aws.ec2.SecurityGroupRule` resource and the `ingress` and `egress` arguments of the `aws.ec2.SecurityGroup` resource for configuring in-line rules, as they struggle with managing multiple CIDR blocks, and tags and descriptions due to the historical lack of unique IDs.
 * !> **WARNING:** You should not use the `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources in conjunction with the `aws.ec2.SecurityGroup` resource with _in-line rules_ (using the `ingress` and `egress` arguments of `aws.ec2.SecurityGroup`) or the `aws.ec2.SecurityGroupRule` resource. Doing so may cause rule conflicts, perpetual differences, and result in rules being overwritten.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.SecurityGroup("example", {
 *     name: "example",
 *     description: "example",
 *     vpcId: main.id,
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * const exampleSecurityGroupIngressRule = new aws.vpc.SecurityGroupIngressRule("example", {
 *     securityGroupId: example.id,
 *     cidrIpv4: "10.0.0.0/8",
 *     fromPort: 80,
 *     ipProtocol: "tcp",
 *     toPort: 80,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.SecurityGroup("example",
 *     name="example",
 *     description="example",
 *     vpc_id=main["id"],
 *     tags={
 *         "Name": "example",
 *     })
 * example_security_group_ingress_rule = aws.vpc.SecurityGroupIngressRule("example",
 *     security_group_id=example.id,
 *     cidr_ipv4="10.0.0.0/8",
 *     from_port=80,
 *     ip_protocol="tcp",
 *     to_port=80)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.SecurityGroup("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         VpcId = main.Id,
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 *     var exampleSecurityGroupIngressRule = new Aws.Vpc.SecurityGroupIngressRule("example", new()
 *     {
 *         SecurityGroupId = example.Id,
 *         CidrIpv4 = "10.0.0.0/8",
 *         FromPort = 80,
 *         IpProtocol = "tcp",
 *         ToPort = 80,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewSecurityGroup(ctx, "example", &ec2.SecurityGroupArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			VpcId:       pulumi.Any(main.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSecurityGroupIngressRule(ctx, "example", &vpc.SecurityGroupIngressRuleArgs{
 * 			SecurityGroupId: example.ID(),
 * 			CidrIpv4:        pulumi.String("10.0.0.0/8"),
 * 			FromPort:        pulumi.Int(80),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			ToPort:          pulumi.Int(80),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRule;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example", SecurityGroupArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .vpcId(main.id())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *         var exampleSecurityGroupIngressRule = new SecurityGroupIngressRule("exampleSecurityGroupIngressRule", SecurityGroupIngressRuleArgs.builder()
 *             .securityGroupId(example.id())
 *             .cidrIpv4("10.0.0.0/8")
 *             .fromPort(80)
 *             .ipProtocol("tcp")
 *             .toPort(80)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:SecurityGroup
 *     properties:
 *       name: example
 *       description: example
 *       vpcId: ${main.id}
 *       tags:
 *         Name: example
 *   exampleSecurityGroupIngressRule:
 *     type: aws:vpc:SecurityGroupIngressRule
 *     name: example
 *     properties:
 *       securityGroupId: ${example.id}
 *       cidrIpv4: 10.0.0.0/8
 *       fromPort: 80
 *       ipProtocol: tcp
 *       toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import security group ingress rules using the `security_group_rule_id`. For example:
 * ```sh
 * $ pulumi import aws:vpc/securityGroupIngressRule:SecurityGroupIngressRule example sgr-02108b27edd666983
 * ```
 */
public class SecurityGroupIngressRule internal constructor(
    override val javaResource: com.pulumi.aws.vpc.SecurityGroupIngressRule,
) : KotlinCustomResource(javaResource, SecurityGroupIngressRuleMapper) {
    /**
     * The Amazon Resource Name (ARN) of the security group rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The source IPv4 CIDR range.
     */
    public val cidrIpv4: Output<String>?
        get() = javaResource.cidrIpv4().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The source IPv6 CIDR range.
     */
    public val cidrIpv6: Output<String>?
        get() = javaResource.cidrIpv6().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The security group rule description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    public val fromPort: Output<Int>?
        get() = javaResource.fromPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    public val ipProtocol: Output<String>
        get() = javaResource.ipProtocol().applyValue({ args0 -> args0 })

    /**
     * The ID of the source prefix list.
     */
    public val prefixListId: Output<String>?
        get() = javaResource.prefixListId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source security group that is referenced in the rule.
     */
    public val referencedSecurityGroupId: Output<String>?
        get() = javaResource.referencedSecurityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the security group.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group rule.
     */
    public val securityGroupRuleId: Output<String>
        get() = javaResource.securityGroupRuleId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    public val toPort: Output<Int>?
        get() = javaResource.toPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SecurityGroupIngressRuleMapper : ResourceMapper<SecurityGroupIngressRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpc.SecurityGroupIngressRule::class == javaResource::class

    override fun map(javaResource: Resource): SecurityGroupIngressRule =
        SecurityGroupIngressRule(javaResource as com.pulumi.aws.vpc.SecurityGroupIngressRule)
}

/**
 * @see [SecurityGroupIngressRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityGroupIngressRule].
 */
public suspend fun securityGroupIngressRule(
    name: String,
    block: suspend SecurityGroupIngressRuleResourceBuilder.() -> Unit,
): SecurityGroupIngressRule {
    val builder = SecurityGroupIngressRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityGroupIngressRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityGroupIngressRule(name: String): SecurityGroupIngressRule {
    val builder = SecurityGroupIngressRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
