@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an inbound (ingress) rule for a security group.
 * When specifying an inbound rule for your security group in a VPC, the configuration must include a source for the traffic.
 * > **NOTE:** Using `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources is the current best practice. Avoid using the `aws.ec2.SecurityGroupRule` resource and the `ingress` and `egress` arguments of the `aws.ec2.SecurityGroup` resource for configuring in-line rules, as they struggle with managing multiple CIDR blocks, and tags and descriptions due to the historical lack of unique IDs.
 * !> **WARNING:** You should not use the `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources in conjunction with the `aws.ec2.SecurityGroup` resource with _in-line rules_ (using the `ingress` and `egress` arguments of `aws.ec2.SecurityGroup`) or the `aws.ec2.SecurityGroupRule` resource. Doing so may cause rule conflicts, perpetual differences, and result in rules being overwritten.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.SecurityGroup("example", {
 *     name: "example",
 *     description: "example",
 *     vpcId: main.id,
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * const exampleSecurityGroupIngressRule = new aws.vpc.SecurityGroupIngressRule("example", {
 *     securityGroupId: example.id,
 *     cidrIpv4: "10.0.0.0/8",
 *     fromPort: 80,
 *     ipProtocol: "tcp",
 *     toPort: 80,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.SecurityGroup("example",
 *     name="example",
 *     description="example",
 *     vpc_id=main["id"],
 *     tags={
 *         "Name": "example",
 *     })
 * example_security_group_ingress_rule = aws.vpc.SecurityGroupIngressRule("example",
 *     security_group_id=example.id,
 *     cidr_ipv4="10.0.0.0/8",
 *     from_port=80,
 *     ip_protocol="tcp",
 *     to_port=80)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.SecurityGroup("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         VpcId = main.Id,
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 *     var exampleSecurityGroupIngressRule = new Aws.Vpc.SecurityGroupIngressRule("example", new()
 *     {
 *         SecurityGroupId = example.Id,
 *         CidrIpv4 = "10.0.0.0/8",
 *         FromPort = 80,
 *         IpProtocol = "tcp",
 *         ToPort = 80,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewSecurityGroup(ctx, "example", &ec2.SecurityGroupArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			VpcId:       pulumi.Any(main.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewSecurityGroupIngressRule(ctx, "example", &vpc.SecurityGroupIngressRuleArgs{
 * 			SecurityGroupId: example.ID(),
 * 			CidrIpv4:        pulumi.String("10.0.0.0/8"),
 * 			FromPort:        pulumi.Int(80),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			ToPort:          pulumi.Int(80),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRule;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example", SecurityGroupArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .vpcId(main.id())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *         var exampleSecurityGroupIngressRule = new SecurityGroupIngressRule("exampleSecurityGroupIngressRule", SecurityGroupIngressRuleArgs.builder()
 *             .securityGroupId(example.id())
 *             .cidrIpv4("10.0.0.0/8")
 *             .fromPort(80)
 *             .ipProtocol("tcp")
 *             .toPort(80)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:SecurityGroup
 *     properties:
 *       name: example
 *       description: example
 *       vpcId: ${main.id}
 *       tags:
 *         Name: example
 *   exampleSecurityGroupIngressRule:
 *     type: aws:vpc:SecurityGroupIngressRule
 *     name: example
 *     properties:
 *       securityGroupId: ${example.id}
 *       cidrIpv4: 10.0.0.0/8
 *       fromPort: 80
 *       ipProtocol: tcp
 *       toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import security group ingress rules using the `security_group_rule_id`. For example:
 * ```sh
 * $ pulumi import aws:vpc/securityGroupIngressRule:SecurityGroupIngressRule example sgr-02108b27edd666983
 * ```
 * @property cidrIpv4 The source IPv4 CIDR range.
 * @property cidrIpv6 The source IPv6 CIDR range.
 * @property description The security group rule description.
 * @property fromPort The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
 * @property ipProtocol The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
 * @property prefixListId The ID of the source prefix list.
 * @property referencedSecurityGroupId The source security group that is referenced in the rule.
 * @property securityGroupId The ID of the security group.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property toPort The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
 */
public data class SecurityGroupIngressRuleArgs(
    public val cidrIpv4: Output<String>? = null,
    public val cidrIpv6: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fromPort: Output<Int>? = null,
    public val ipProtocol: Output<String>? = null,
    public val prefixListId: Output<String>? = null,
    public val referencedSecurityGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs> {
    override fun toJava(): com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs =
        com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs.builder()
            .cidrIpv4(cidrIpv4?.applyValue({ args0 -> args0 }))
            .cidrIpv6(cidrIpv6?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .prefixListId(prefixListId?.applyValue({ args0 -> args0 }))
            .referencedSecurityGroupId(referencedSecurityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupIngressRuleArgs].
 */
@PulumiTagMarker
public class SecurityGroupIngressRuleArgsBuilder internal constructor() {
    private var cidrIpv4: Output<String>? = null

    private var cidrIpv6: Output<String>? = null

    private var description: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var ipProtocol: Output<String>? = null

    private var prefixListId: Output<String>? = null

    private var referencedSecurityGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The source IPv4 CIDR range.
     */
    @JvmName("xyoihvuxngmtlgpj")
    public suspend fun cidrIpv4(`value`: Output<String>) {
        this.cidrIpv4 = value
    }

    /**
     * @param value The source IPv6 CIDR range.
     */
    @JvmName("rumqswstjvkfiitb")
    public suspend fun cidrIpv6(`value`: Output<String>) {
        this.cidrIpv6 = value
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("vpucpdgjxvwraqqx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("qvaujygpqstlctut")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("hseksngidqdjvntx")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The ID of the source prefix list.
     */
    @JvmName("wmpckdvmgckdwoss")
    public suspend fun prefixListId(`value`: Output<String>) {
        this.prefixListId = value
    }

    /**
     * @param value The source security group that is referenced in the rule.
     */
    @JvmName("dnpwkdhwixxikkch")
    public suspend fun referencedSecurityGroupId(`value`: Output<String>) {
        this.referencedSecurityGroupId = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("soiqcocptwjuvaly")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gchkdflxqtflylti")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("nqpcyhjycnxiofpj")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The source IPv4 CIDR range.
     */
    @JvmName("bkhatstfirkpxouu")
    public suspend fun cidrIpv4(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv4 = mapped
    }

    /**
     * @param value The source IPv6 CIDR range.
     */
    @JvmName("tuyfgkbxldojdkia")
    public suspend fun cidrIpv6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv6 = mapped
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("jbbgvjroayxipqlj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("lovqoryramxvjgql")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("gybibqcmxlqtyrfl")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The ID of the source prefix list.
     */
    @JvmName("bupnnnmerfistwik")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListId = mapped
    }

    /**
     * @param value The source security group that is referenced in the rule.
     */
    @JvmName("lkfhpckhitkmcaae")
    public suspend fun referencedSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referencedSecurityGroupId = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("eoljtqsslvfauhnx")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("duaaingrvibmgycr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("osfvgittmkcvdhve")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("idprbhhyhovfdcbc")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): SecurityGroupIngressRuleArgs = SecurityGroupIngressRuleArgs(
        cidrIpv4 = cidrIpv4,
        cidrIpv6 = cidrIpv6,
        description = description,
        fromPort = fromPort,
        ipProtocol = ipProtocol,
        prefixListId = prefixListId,
        referencedSecurityGroupId = referencedSecurityGroupId,
        securityGroupId = securityGroupId,
        tags = tags,
        toPort = toPort,
    )
}
