@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.aws.vpc.VpcFunctions.getSecurityGroupRulePlain
import com.pulumi.aws.vpc.VpcFunctions.getSecurityGroupRulesPlain
import com.pulumi.aws.vpc.kotlin.inputs.GetSecurityGroupRuleFilter
import com.pulumi.aws.vpc.kotlin.inputs.GetSecurityGroupRulePlainArgs
import com.pulumi.aws.vpc.kotlin.inputs.GetSecurityGroupRulePlainArgsBuilder
import com.pulumi.aws.vpc.kotlin.inputs.GetSecurityGroupRulesFilter
import com.pulumi.aws.vpc.kotlin.inputs.GetSecurityGroupRulesPlainArgs
import com.pulumi.aws.vpc.kotlin.inputs.GetSecurityGroupRulesPlainArgsBuilder
import com.pulumi.aws.vpc.kotlin.outputs.GetSecurityGroupRuleResult
import com.pulumi.aws.vpc.kotlin.outputs.GetSecurityGroupRulesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.vpc.kotlin.outputs.GetSecurityGroupRuleResult.Companion.toKotlin as getSecurityGroupRuleResultToKotlin
import com.pulumi.aws.vpc.kotlin.outputs.GetSecurityGroupRulesResult.Companion.toKotlin as getSecurityGroupRulesResultToKotlin

public object VpcFunctions {
    /**
     * `aws.vpc.getSecurityGroupRule` provides details about a specific security group rule.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.vpc.getSecurityGroupRule({
     *     securityGroupRuleId: securityGroupRuleId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.vpc.get_security_group_rule(security_group_rule_id=security_group_rule_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Vpc.GetSecurityGroupRule.Invoke(new()
     *     {
     *         SecurityGroupRuleId = securityGroupRuleId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := vpc.GetSecurityGroupRule(ctx, &vpc.GetSecurityGroupRuleArgs{
     * 			SecurityGroupRuleId: pulumi.StringRef(securityGroupRuleId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.vpc.VpcFunctions;
     * import com.pulumi.aws.vpc.inputs.GetSecurityGroupRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpcFunctions.getSecurityGroupRule(GetSecurityGroupRuleArgs.builder()
     *             .securityGroupRuleId(securityGroupRuleId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:vpc:getSecurityGroupRule
     *       Arguments:
     *         securityGroupRuleId: ${securityGroupRuleId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityGroupRule.
     * @return A collection of values returned by getSecurityGroupRule.
     */
    public suspend fun getSecurityGroupRule(argument: GetSecurityGroupRulePlainArgs): GetSecurityGroupRuleResult =
        getSecurityGroupRuleResultToKotlin(getSecurityGroupRulePlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroupRule].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param securityGroupRuleId ID of the security group rule to select.
     * @return A collection of values returned by getSecurityGroupRule.
     */
    public suspend fun getSecurityGroupRule(
        filters: List<GetSecurityGroupRuleFilter>? = null,
        securityGroupRuleId: String? = null,
    ): GetSecurityGroupRuleResult {
        val argument = GetSecurityGroupRulePlainArgs(
            filters = filters,
            securityGroupRuleId = securityGroupRuleId,
        )
        return getSecurityGroupRuleResultToKotlin(getSecurityGroupRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroupRule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;vpc&#46;kotlin&#46;inputs&#46;GetSecurityGroupRulePlainArgs].
     * @return A collection of values returned by getSecurityGroupRule.
     */
    public suspend fun getSecurityGroupRule(argument: suspend GetSecurityGroupRulePlainArgsBuilder.() -> Unit): GetSecurityGroupRuleResult {
        val builder = GetSecurityGroupRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupRuleResultToKotlin(getSecurityGroupRulePlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a set of security group rule IDs.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.vpc.getSecurityGroupRules({
     *     filters: [{
     *         name: "group-id",
     *         values: [securityGroupId],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.vpc.get_security_group_rules(filters=[{
     *     "name": "group-id",
     *     "values": [security_group_id],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Vpc.GetSecurityGroupRules.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Vpc.Inputs.GetSecurityGroupRulesFilterInputArgs
     *             {
     *                 Name = "group-id",
     *                 Values = new[]
     *                 {
     *                     securityGroupId,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := vpc.GetSecurityGroupRules(ctx, &vpc.GetSecurityGroupRulesArgs{
     * Filters: []vpc.GetSecurityGroupRulesFilter{
     * {
     * Name: "group-id",
     * Values: interface{}{
     * securityGroupId,
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.vpc.VpcFunctions;
     * import com.pulumi.aws.vpc.inputs.GetSecurityGroupRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpcFunctions.getSecurityGroupRules(GetSecurityGroupRulesArgs.builder()
     *             .filters(GetSecurityGroupRulesFilterArgs.builder()
     *                 .name("group-id")
     *                 .values(securityGroupId)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:vpc:getSecurityGroupRules
     *       Arguments:
     *         filters:
     *           - name: group-id
     *             values:
     *               - ${securityGroupId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityGroupRules.
     * @return A collection of values returned by getSecurityGroupRules.
     */
    public suspend fun getSecurityGroupRules(argument: GetSecurityGroupRulesPlainArgs): GetSecurityGroupRulesResult =
        getSecurityGroupRulesResultToKotlin(getSecurityGroupRulesPlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroupRules].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired security group rule.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getSecurityGroupRules.
     */
    public suspend fun getSecurityGroupRules(
        filters: List<GetSecurityGroupRulesFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetSecurityGroupRulesResult {
        val argument = GetSecurityGroupRulesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getSecurityGroupRulesResultToKotlin(getSecurityGroupRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroupRules].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;vpc&#46;kotlin&#46;inputs&#46;GetSecurityGroupRulesPlainArgs].
     * @return A collection of values returned by getSecurityGroupRules.
     */
    public suspend fun getSecurityGroupRules(argument: suspend GetSecurityGroupRulesPlainArgsBuilder.() -> Unit): GetSecurityGroupRulesResult {
        val builder = GetSecurityGroupRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupRulesResultToKotlin(getSecurityGroupRulesPlain(builtArgument.toJava()).await())
    }
}
