@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin.inputs

import com.pulumi.aws.vpc.inputs.GetSecurityGroupRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityGroupRule.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property securityGroupRuleId ID of the security group rule to select.
 */
public data class GetSecurityGroupRulePlainArgs(
    public val filters: List<GetSecurityGroupRuleFilter>? = null,
    public val securityGroupRuleId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.vpc.inputs.GetSecurityGroupRulePlainArgs> {
    override fun toJava(): com.pulumi.aws.vpc.inputs.GetSecurityGroupRulePlainArgs =
        com.pulumi.aws.vpc.inputs.GetSecurityGroupRulePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .securityGroupRuleId(securityGroupRuleId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityGroupRulePlainArgs].
 */
@PulumiTagMarker
public class GetSecurityGroupRulePlainArgsBuilder internal constructor() {
    private var filters: List<GetSecurityGroupRuleFilter>? = null

    private var securityGroupRuleId: String? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("vqmhywkbuavfcefc")
    public suspend fun filters(`value`: List<GetSecurityGroupRuleFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("shkknangahgpmcdd")
    public suspend fun filters(argument: List<suspend GetSecurityGroupRuleFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupRuleFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("exrhgggfargvmugq")
    public suspend fun filters(vararg argument: suspend GetSecurityGroupRuleFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupRuleFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("pmuckoyconldrkok")
    public suspend fun filters(argument: suspend GetSecurityGroupRuleFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSecurityGroupRuleFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("pfgplontxapghmws")
    public suspend fun filters(vararg values: GetSecurityGroupRuleFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the security group rule to select.
     */
    @JvmName("dsutcnktjhiwvqhi")
    public suspend fun securityGroupRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityGroupRuleId = mapped
    }

    internal fun build(): GetSecurityGroupRulePlainArgs = GetSecurityGroupRulePlainArgs(
        filters = filters,
        securityGroupRuleId = securityGroupRuleId,
    )
}
