@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin.inputs

import com.pulumi.aws.vpc.inputs.GetSecurityGroupRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityGroupRules.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired security group rule.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetSecurityGroupRulesPlainArgs(
    public val filters: List<GetSecurityGroupRulesFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpc.inputs.GetSecurityGroupRulesPlainArgs> {
    override fun toJava(): com.pulumi.aws.vpc.inputs.GetSecurityGroupRulesPlainArgs =
        com.pulumi.aws.vpc.inputs.GetSecurityGroupRulesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSecurityGroupRulesPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityGroupRulesPlainArgsBuilder internal constructor() {
    private var filters: List<GetSecurityGroupRulesFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("strdcjmmxtjqwicq")
    public suspend fun filters(`value`: List<GetSecurityGroupRulesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("geeucitjsaiyewfw")
    public suspend fun filters(argument: List<suspend GetSecurityGroupRulesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupRulesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("irjicsiuhafjnagq")
    public suspend fun filters(vararg argument: suspend GetSecurityGroupRulesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupRulesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("cklvplncgaotkktu")
    public suspend fun filters(argument: suspend GetSecurityGroupRulesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetSecurityGroupRulesFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("yqggfpvwhaqxqaun")
    public suspend fun filters(vararg values: GetSecurityGroupRulesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired security group rule.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("prqxjetvqkmghydq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired security group rule.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("odacofrugyrtendg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSecurityGroupRulesPlainArgs = GetSecurityGroupRulesPlainArgs(
        filters = filters,
        tags = tags,
    )
}
