@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSecurityGroupRule.
 * @property arn The Amazon Resource Name (ARN) of the security group rule.
 * @property cidrIpv4 The destination IPv4 CIDR range.
 * @property cidrIpv6 The destination IPv6 CIDR range.
 * @property description The security group rule description.
 * @property filters
 * @property fromPort The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
 * @property id
 * @property ipProtocol The IP protocol name or number. Use `-1` to specify all protocols.
 * @property isEgress Indicates whether the security group rule is an outbound rule.
 * @property prefixListId The ID of the destination prefix list.
 * @property referencedSecurityGroupId The destination security group that is referenced in the rule.
 * @property securityGroupId The ID of the security group.
 * @property securityGroupRuleId
 * @property tags A map of tags assigned to the resource.
 * @property toPort (Optional) The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
 */
public data class GetSecurityGroupRuleResult(
    public val arn: String,
    public val cidrIpv4: String,
    public val cidrIpv6: String,
    public val description: String,
    public val filters: List<GetSecurityGroupRuleFilter>? = null,
    public val fromPort: Int,
    public val id: String,
    public val ipProtocol: String,
    public val isEgress: Boolean,
    public val prefixListId: String,
    public val referencedSecurityGroupId: String,
    public val securityGroupId: String,
    public val securityGroupRuleId: String,
    public val tags: Map<String, String>,
    public val toPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpc.outputs.GetSecurityGroupRuleResult): GetSecurityGroupRuleResult = GetSecurityGroupRuleResult(
            arn = javaType.arn(),
            cidrIpv4 = javaType.cidrIpv4(),
            cidrIpv6 = javaType.cidrIpv6(),
            description = javaType.description(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpc.kotlin.outputs.GetSecurityGroupRuleFilter.Companion.toKotlin(args0)
                })
            }),
            fromPort = javaType.fromPort(),
            id = javaType.id(),
            ipProtocol = javaType.ipProtocol(),
            isEgress = javaType.isEgress(),
            prefixListId = javaType.prefixListId(),
            referencedSecurityGroupId = javaType.referencedSecurityGroupId(),
            securityGroupId = javaType.securityGroupId(),
            securityGroupRuleId = javaType.securityGroupRuleId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            toPort = javaType.toPort(),
        )
    }
}
