@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSecurityGroupRules.
 * @property filters
 * @property id
 * @property ids List of all the security group rule IDs found.
 * @property tags
 */
public data class GetSecurityGroupRulesResult(
    public val filters: List<GetSecurityGroupRulesFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpc.outputs.GetSecurityGroupRulesResult): GetSecurityGroupRulesResult = GetSecurityGroupRulesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpc.kotlin.outputs.GetSecurityGroupRulesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
