@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Service Network or Service Access log subscription.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.AccessLogSubscription("example", {
 *     resourceIdentifier: exampleAwsVpclatticeServiceNetwork.id,
 *     destinationArn: bucket.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.AccessLogSubscription("example",
 *     resource_identifier=example_aws_vpclattice_service_network["id"],
 *     destination_arn=bucket["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.AccessLogSubscription("example", new()
 *     {
 *         ResourceIdentifier = exampleAwsVpclatticeServiceNetwork.Id,
 *         DestinationArn = bucket.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewAccessLogSubscription(ctx, "example", &vpclattice.AccessLogSubscriptionArgs{
 * 			ResourceIdentifier: pulumi.Any(exampleAwsVpclatticeServiceNetwork.Id),
 * 			DestinationArn:     pulumi.Any(bucket.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.AccessLogSubscription;
 * import com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessLogSubscription("example", AccessLogSubscriptionArgs.builder()
 *             .resourceIdentifier(exampleAwsVpclatticeServiceNetwork.id())
 *             .destinationArn(bucket.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:AccessLogSubscription
 *     properties:
 *       resourceIdentifier: ${exampleAwsVpclatticeServiceNetwork.id}
 *       destinationArn: ${bucket.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Access Log Subscription using the access log subscription ID. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/accessLogSubscription:AccessLogSubscription example rft-8012925589
 * ```
 * @property destinationArn Amazon Resource Name (ARN) of the log destination.
 * @property resourceIdentifier The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
 * @property tags
 */
public data class AccessLogSubscriptionArgs(
    public val destinationArn: Output<String>? = null,
    public val resourceIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs =
        com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs.builder()
            .destinationArn(destinationArn?.applyValue({ args0 -> args0 }))
            .resourceIdentifier(resourceIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccessLogSubscriptionArgs].
 */
@PulumiTagMarker
public class AccessLogSubscriptionArgsBuilder internal constructor() {
    private var destinationArn: Output<String>? = null

    private var resourceIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the log destination.
     */
    @JvmName("nqpcmdolnhlscusx")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
     */
    @JvmName("iylovpgmgnsepilg")
    public suspend fun resourceIdentifier(`value`: Output<String>) {
        this.resourceIdentifier = value
    }

    /**
     * @param value
     */
    @JvmName("erqeqrywhmeryxns")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the log destination.
     */
    @JvmName("dbfyyqvirllkwaip")
    public suspend fun destinationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
     */
    @JvmName("ftgftrxtbobtawfb")
    public suspend fun resourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdentifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("kkgxxaxyunqaehqp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("lmwarfiqbrheucbp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccessLogSubscriptionArgs = AccessLogSubscriptionArgs(
        destinationArn = destinationArn,
        resourceIdentifier = resourceIdentifier,
        tags = tags,
    )
}
