@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AuthPolicy].
 */
@PulumiTagMarker
public class AuthPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthPolicyArgs = AuthPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthPolicyArgsBuilder.() -> Unit) {
        val builder = AuthPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AuthPolicy {
        val builtJavaResource = com.pulumi.aws.vpclattice.AuthPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AuthPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Auth Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.Service("example", {
 *     name: "example-vpclattice-service",
 *     authType: "AWS_IAM",
 *     customDomainName: "example.com",
 * });
 * const exampleAuthPolicy = new aws.vpclattice.AuthPolicy("example", {
 *     resourceIdentifier: example.arn,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "*",
 *             Effect: "Allow",
 *             Principal: "*",
 *             Resource: "*",
 *             Condition: {
 *                 StringNotEqualsIgnoreCase: {
 *                     "aws:PrincipalType": "anonymous",
 *                 },
 *             },
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.vpclattice.Service("example",
 *     name="example-vpclattice-service",
 *     auth_type="AWS_IAM",
 *     custom_domain_name="example.com")
 * example_auth_policy = aws.vpclattice.AuthPolicy("example",
 *     resource_identifier=example.arn,
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "*",
 *             "Effect": "Allow",
 *             "Principal": "*",
 *             "Resource": "*",
 *             "Condition": {
 *                 "StringNotEqualsIgnoreCase": {
 *                     "aws:PrincipalType": "anonymous",
 *                 },
 *             },
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.Service("example", new()
 *     {
 *         Name = "example-vpclattice-service",
 *         AuthType = "AWS_IAM",
 *         CustomDomainName = "example.com",
 *     });
 *     var exampleAuthPolicy = new Aws.VpcLattice.AuthPolicy("example", new()
 *     {
 *         ResourceIdentifier = example.Arn,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "*",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = "*",
 *                     ["Resource"] = "*",
 *                     ["Condition"] = new Dictionary<string, object?>
 *                     {
 *                         ["StringNotEqualsIgnoreCase"] = new Dictionary<string, object?>
 *                         {
 *                             ["aws:PrincipalType"] = "anonymous",
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := vpclattice.NewService(ctx, "example", &vpclattice.ServiceArgs{
 * 			Name:             pulumi.String("example-vpclattice-service"),
 * 			AuthType:         pulumi.String("AWS_IAM"),
 * 			CustomDomainName: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action":    "*",
 * 					"Effect":    "Allow",
 * 					"Principal": "*",
 * 					"Resource":  "*",
 * 					"Condition": map[string]interface{}{
 * 						"StringNotEqualsIgnoreCase": map[string]interface{}{
 * 							"aws:PrincipalType": "anonymous",
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = vpclattice.NewAuthPolicy(ctx, "example", &vpclattice.AuthPolicyArgs{
 * 			ResourceIdentifier: example.Arn,
 * 			Policy:             pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import com.pulumi.aws.vpclattice.AuthPolicy;
 * import com.pulumi.aws.vpclattice.AuthPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example-vpclattice-service")
 *             .authType("AWS_IAM")
 *             .customDomainName("example.com")
 *             .build());
 *         var exampleAuthPolicy = new AuthPolicy("exampleAuthPolicy", AuthPolicyArgs.builder()
 *             .resourceIdentifier(example.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "*"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", "*"),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("StringNotEqualsIgnoreCase", jsonObject(
 *                                 jsonProperty("aws:PrincipalType", "anonymous")
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:Service
 *     properties:
 *       name: example-vpclattice-service
 *       authType: AWS_IAM
 *       customDomainName: example.com
 *   exampleAuthPolicy:
 *     type: aws:vpclattice:AuthPolicy
 *     name: example
 *     properties:
 *       resourceIdentifier: ${example.arn}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: '*'
 *               Effect: Allow
 *               Principal: '*'
 *               Resource: '*'
 *               Condition:
 *                 StringNotEqualsIgnoreCase:
 *                   aws:PrincipalType: anonymous
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Auth Policy using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/authPolicy:AuthPolicy example abcd-12345678
 * ```
 */
public class AuthPolicy internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.AuthPolicy,
) : KotlinCustomResource(javaResource, AuthPolicyMapper) {
    /**
     * The auth policy. The policy string in JSON must not contain newlines or blank lines.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    public val resourceIdentifier: Output<String>
        get() = javaResource.resourceIdentifier().applyValue({ args0 -> args0 })

    /**
     * The state of the auth policy. The auth policy is only active when the auth type is set to `AWS_IAM`. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is `NONE`, then, any auth policy you provide will remain inactive.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AuthPolicyMapper : ResourceMapper<AuthPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.AuthPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AuthPolicy = AuthPolicy(
        javaResource as
            com.pulumi.aws.vpclattice.AuthPolicy,
    )
}

/**
 * @see [AuthPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuthPolicy].
 */
public suspend fun authPolicy(name: String, block: suspend AuthPolicyResourceBuilder.() -> Unit): AuthPolicy {
    val builder = AuthPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuthPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authPolicy(name: String): AuthPolicy {
    val builder = AuthPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
