@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerDefaultAction
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerDefaultAction.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Listener].
 */
@PulumiTagMarker
public class ListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerArgs = ListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerArgsBuilder.() -> Unit) {
        val builder = ListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Listener {
        val builtJavaResource = com.pulumi.aws.vpclattice.Listener(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Listener(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Listener.
 * ## Example Usage
 * ### Fixed response action
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.Service("example", {name: "example"});
 * const exampleListener = new aws.vpclattice.Listener("example", {
 *     name: "example",
 *     protocol: "HTTPS",
 *     serviceIdentifier: example.id,
 *     defaultAction: {
 *         fixedResponse: {
 *             statusCode: 404,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.Service("example", name="example")
 * example_listener = aws.vpclattice.Listener("example",
 *     name="example",
 *     protocol="HTTPS",
 *     service_identifier=example.id,
 *     default_action={
 *         "fixed_response": {
 *             "status_code": 404,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.Service("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleListener = new Aws.VpcLattice.Listener("example", new()
 *     {
 *         Name = "example",
 *         Protocol = "HTTPS",
 *         ServiceIdentifier = example.Id,
 *         DefaultAction = new Aws.VpcLattice.Inputs.ListenerDefaultActionArgs
 *         {
 *             FixedResponse = new Aws.VpcLattice.Inputs.ListenerDefaultActionFixedResponseArgs
 *             {
 *                 StatusCode = 404,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := vpclattice.NewService(ctx, "example", &vpclattice.ServiceArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpclattice.NewListener(ctx, "example", &vpclattice.ListenerArgs{
 * 			Name:              pulumi.String("example"),
 * 			Protocol:          pulumi.String("HTTPS"),
 * 			ServiceIdentifier: example.ID(),
 * 			DefaultAction: &vpclattice.ListenerDefaultActionArgs{
 * 				FixedResponse: &vpclattice.ListenerDefaultActionFixedResponseArgs{
 * 					StatusCode: pulumi.Int(404),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import com.pulumi.aws.vpclattice.Listener;
 * import com.pulumi.aws.vpclattice.ListenerArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionFixedResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .name("example")
 *             .protocol("HTTPS")
 *             .serviceIdentifier(example.id())
 *             .defaultAction(ListenerDefaultActionArgs.builder()
 *                 .fixedResponse(ListenerDefaultActionFixedResponseArgs.builder()
 *                     .statusCode(404)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:Service
 *     properties:
 *       name: example
 *   exampleListener:
 *     type: aws:vpclattice:Listener
 *     name: example
 *     properties:
 *       name: example
 *       protocol: HTTPS
 *       serviceIdentifier: ${example.id}
 *       defaultAction:
 *         fixedResponse:
 *           statusCode: 404
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Forward action
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.Service("example", {name: "example"});
 * const exampleTargetGroup = new aws.vpclattice.TargetGroup("example", {
 *     name: "example-target-group-1",
 *     type: "INSTANCE",
 *     config: {
 *         port: 80,
 *         protocol: "HTTP",
 *         vpcIdentifier: exampleAwsVpc.id,
 *     },
 * });
 * const exampleListener = new aws.vpclattice.Listener("example", {
 *     name: "example",
 *     protocol: "HTTP",
 *     serviceIdentifier: example.id,
 *     defaultAction: {
 *         forwards: [{
 *             targetGroups: [{
 *                 targetGroupIdentifier: exampleTargetGroup.id,
 *             }],
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.Service("example", name="example")
 * example_target_group = aws.vpclattice.TargetGroup("example",
 *     name="example-target-group-1",
 *     type="INSTANCE",
 *     config={
 *         "port": 80,
 *         "protocol": "HTTP",
 *         "vpc_identifier": example_aws_vpc["id"],
 *     })
 * example_listener = aws.vpclattice.Listener("example",
 *     name="example",
 *     protocol="HTTP",
 *     service_identifier=example.id,
 *     default_action={
 *         "forwards": [{
 *             "target_groups": [{
 *                 "target_group_identifier": example_target_group.id,
 *             }],
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.Service("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleTargetGroup = new Aws.VpcLattice.TargetGroup("example", new()
 *     {
 *         Name = "example-target-group-1",
 *         Type = "INSTANCE",
 *         Config = new Aws.VpcLattice.Inputs.TargetGroupConfigArgs
 *         {
 *             Port = 80,
 *             Protocol = "HTTP",
 *             VpcIdentifier = exampleAwsVpc.Id,
 *         },
 *     });
 *     var exampleListener = new Aws.VpcLattice.Listener("example", new()
 *     {
 *         Name = "example",
 *         Protocol = "HTTP",
 *         ServiceIdentifier = example.Id,
 *         DefaultAction = new Aws.VpcLattice.Inputs.ListenerDefaultActionArgs
 *         {
 *             Forwards = new[]
 *             {
 *                 new Aws.VpcLattice.Inputs.ListenerDefaultActionForwardArgs
 *                 {
 *                     TargetGroups = new[]
 *                     {
 *                         new Aws.VpcLattice.Inputs.ListenerDefaultActionForwardTargetGroupArgs
 *                         {
 *                             TargetGroupIdentifier = exampleTargetGroup.Id,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := vpclattice.NewService(ctx, "example", &vpclattice.ServiceArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTargetGroup, err := vpclattice.NewTargetGroup(ctx, "example", &vpclattice.TargetGroupArgs{
 * 			Name: pulumi.String("example-target-group-1"),
 * 			Type: pulumi.String("INSTANCE"),
 * 			Config: &vpclattice.TargetGroupConfigArgs{
 * 				Port:          pulumi.Int(80),
 * 				Protocol:      pulumi.String("HTTP"),
 * 				VpcIdentifier: pulumi.Any(exampleAwsVpc.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpclattice.NewListener(ctx, "example", &vpclattice.ListenerArgs{
 * 			Name:              pulumi.String("example"),
 * 			Protocol:          pulumi.String("HTTP"),
 * 			ServiceIdentifier: example.ID(),
 * 			DefaultAction: &vpclattice.ListenerDefaultActionArgs{
 * 				Forwards: vpclattice.ListenerDefaultActionForwardArray{
 * 					&vpclattice.ListenerDefaultActionForwardArgs{
 * 						TargetGroups: vpclattice.ListenerDefaultActionForwardTargetGroupArray{
 * 							&vpclattice.ListenerDefaultActionForwardTargetGroupArgs{
 * 								TargetGroupIdentifier: exampleTargetGroup.ID(),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.Listener;
 * import com.pulumi.aws.vpclattice.ListenerArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleTargetGroup = new TargetGroup("exampleTargetGroup", TargetGroupArgs.builder()
 *             .name("example-target-group-1")
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(exampleAwsVpc.id())
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .name("example")
 *             .protocol("HTTP")
 *             .serviceIdentifier(example.id())
 *             .defaultAction(ListenerDefaultActionArgs.builder()
 *                 .forwards(ListenerDefaultActionForwardArgs.builder()
 *                     .targetGroups(ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                         .targetGroupIdentifier(exampleTargetGroup.id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:Service
 *     properties:
 *       name: example
 *   exampleTargetGroup:
 *     type: aws:vpclattice:TargetGroup
 *     name: example
 *     properties:
 *       name: example-target-group-1
 *       type: INSTANCE
 *       config:
 *         port: 80
 *         protocol: HTTP
 *         vpcIdentifier: ${exampleAwsVpc.id}
 *   exampleListener:
 *     type: aws:vpclattice:Listener
 *     name: example
 *     properties:
 *       name: example
 *       protocol: HTTP
 *       serviceIdentifier: ${example.id}
 *       defaultAction:
 *         forwards:
 *           - targetGroups:
 *               - targetGroupIdentifier: ${exampleTargetGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Forward action with weighted target groups
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.Service("example", {name: "example"});
 * const example1 = new aws.vpclattice.TargetGroup("example1", {
 *     name: "example-target-group-1",
 *     type: "INSTANCE",
 *     config: {
 *         port: 80,
 *         protocol: "HTTP",
 *         vpcIdentifier: exampleAwsVpc.id,
 *     },
 * });
 * const example2 = new aws.vpclattice.TargetGroup("example2", {
 *     name: "example-target-group-2",
 *     type: "INSTANCE",
 *     config: {
 *         port: 8080,
 *         protocol: "HTTP",
 *         vpcIdentifier: exampleAwsVpc.id,
 *     },
 * });
 * const exampleListener = new aws.vpclattice.Listener("example", {
 *     name: "example",
 *     protocol: "HTTP",
 *     serviceIdentifier: example.id,
 *     defaultAction: {
 *         forwards: [{
 *             targetGroups: [
 *                 {
 *                     targetGroupIdentifier: example1.id,
 *                     weight: 80,
 *                 },
 *                 {
 *                     targetGroupIdentifier: example2.id,
 *                     weight: 20,
 *                 },
 *             ],
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.Service("example", name="example")
 * example1 = aws.vpclattice.TargetGroup("example1",
 *     name="example-target-group-1",
 *     type="INSTANCE",
 *     config={
 *         "port": 80,
 *         "protocol": "HTTP",
 *         "vpc_identifier": example_aws_vpc["id"],
 *     })
 * example2 = aws.vpclattice.TargetGroup("example2",
 *     name="example-target-group-2",
 *     type="INSTANCE",
 *     config={
 *         "port": 8080,
 *         "protocol": "HTTP",
 *         "vpc_identifier": example_aws_vpc["id"],
 *     })
 * example_listener = aws.vpclattice.Listener("example",
 *     name="example",
 *     protocol="HTTP",
 *     service_identifier=example.id,
 *     default_action={
 *         "forwards": [{
 *             "target_groups": [
 *                 {
 *                     "target_group_identifier": example1.id,
 *                     "weight": 80,
 *                 },
 *                 {
 *                     "target_group_identifier": example2.id,
 *                     "weight": 20,
 *                 },
 *             ],
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.Service("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var example1 = new Aws.VpcLattice.TargetGroup("example1", new()
 *     {
 *         Name = "example-target-group-1",
 *         Type = "INSTANCE",
 *         Config = new Aws.VpcLattice.Inputs.TargetGroupConfigArgs
 *         {
 *             Port = 80,
 *             Protocol = "HTTP",
 *             VpcIdentifier = exampleAwsVpc.Id,
 *         },
 *     });
 *     var example2 = new Aws.VpcLattice.TargetGroup("example2", new()
 *     {
 *         Name = "example-target-group-2",
 *         Type = "INSTANCE",
 *         Config = new Aws.VpcLattice.Inputs.TargetGroupConfigArgs
 *         {
 *             Port = 8080,
 *             Protocol = "HTTP",
 *             VpcIdentifier = exampleAwsVpc.Id,
 *         },
 *     });
 *     var exampleListener = new Aws.VpcLattice.Listener("example", new()
 *     {
 *         Name = "example",
 *         Protocol = "HTTP",
 *         ServiceIdentifier = example.Id,
 *         DefaultAction = new Aws.VpcLattice.Inputs.ListenerDefaultActionArgs
 *         {
 *             Forwards = new[]
 *             {
 *                 new Aws.VpcLattice.Inputs.ListenerDefaultActionForwardArgs
 *                 {
 *                     TargetGroups = new[]
 *                     {
 *                         new Aws.VpcLattice.Inputs.ListenerDefaultActionForwardTargetGroupArgs
 *                         {
 *                             TargetGroupIdentifier = example1.Id,
 *                             Weight = 80,
 *                         },
 *                         new Aws.VpcLattice.Inputs.ListenerDefaultActionForwardTargetGroupArgs
 *                         {
 *                             TargetGroupIdentifier = example2.Id,
 *                             Weight = 20,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := vpclattice.NewService(ctx, "example", &vpclattice.ServiceArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example1, err := vpclattice.NewTargetGroup(ctx, "example1", &vpclattice.TargetGroupArgs{
 * 			Name: pulumi.String("example-target-group-1"),
 * 			Type: pulumi.String("INSTANCE"),
 * 			Config: &vpclattice.TargetGroupConfigArgs{
 * 				Port:          pulumi.Int(80),
 * 				Protocol:      pulumi.String("HTTP"),
 * 				VpcIdentifier: pulumi.Any(exampleAwsVpc.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example2, err := vpclattice.NewTargetGroup(ctx, "example2", &vpclattice.TargetGroupArgs{
 * 			Name: pulumi.String("example-target-group-2"),
 * 			Type: pulumi.String("INSTANCE"),
 * 			Config: &vpclattice.TargetGroupConfigArgs{
 * 				Port:          pulumi.Int(8080),
 * 				Protocol:      pulumi.String("HTTP"),
 * 				VpcIdentifier: pulumi.Any(exampleAwsVpc.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpclattice.NewListener(ctx, "example", &vpclattice.ListenerArgs{
 * 			Name:              pulumi.String("example"),
 * 			Protocol:          pulumi.String("HTTP"),
 * 			ServiceIdentifier: example.ID(),
 * 			DefaultAction: &vpclattice.ListenerDefaultActionArgs{
 * 				Forwards: vpclattice.ListenerDefaultActionForwardArray{
 * 					&vpclattice.ListenerDefaultActionForwardArgs{
 * 						TargetGroups: vpclattice.ListenerDefaultActionForwardTargetGroupArray{
 * 							&vpclattice.ListenerDefaultActionForwardTargetGroupArgs{
 * 								TargetGroupIdentifier: example1.ID(),
 * 								Weight:                pulumi.Int(80),
 * 							},
 * 							&vpclattice.ListenerDefaultActionForwardTargetGroupArgs{
 * 								TargetGroupIdentifier: example2.ID(),
 * 								Weight:                pulumi.Int(20),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.Listener;
 * import com.pulumi.aws.vpclattice.ListenerArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .build());
 *         var example1 = new TargetGroup("example1", TargetGroupArgs.builder()
 *             .name("example-target-group-1")
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(exampleAwsVpc.id())
 *                 .build())
 *             .build());
 *         var example2 = new TargetGroup("example2", TargetGroupArgs.builder()
 *             .name("example-target-group-2")
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(8080)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(exampleAwsVpc.id())
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .name("example")
 *             .protocol("HTTP")
 *             .serviceIdentifier(example.id())
 *             .defaultAction(ListenerDefaultActionArgs.builder()
 *                 .forwards(ListenerDefaultActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example1.id())
 *                             .weight(80)
 *                             .build(),
 *                         ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example2.id())
 *                             .weight(20)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:Service
 *     properties:
 *       name: example
 *   example1:
 *     type: aws:vpclattice:TargetGroup
 *     properties:
 *       name: example-target-group-1
 *       type: INSTANCE
 *       config:
 *         port: 80
 *         protocol: HTTP
 *         vpcIdentifier: ${exampleAwsVpc.id}
 *   example2:
 *     type: aws:vpclattice:TargetGroup
 *     properties:
 *       name: example-target-group-2
 *       type: INSTANCE
 *       config:
 *         port: 8080
 *         protocol: HTTP
 *         vpcIdentifier: ${exampleAwsVpc.id}
 *   exampleListener:
 *     type: aws:vpclattice:Listener
 *     name: example
 *     properties:
 *       name: example
 *       protocol: HTTP
 *       serviceIdentifier: ${example.id}
 *       defaultAction:
 *         forwards:
 *           - targetGroups:
 *               - targetGroupIdentifier: ${example1.id}
 *                 weight: 80
 *               - targetGroupIdentifier: ${example2.id}
 *                 weight: 20
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Listener using the `listener_id` of the listener and the `id` of the VPC Lattice service combined with a `/` character. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/listener:Listener example svc-1a2b3c4d/listener-987654321
 * ```
 */
public class Listener internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.Listener,
) : KotlinCustomResource(javaResource, ListenerMapper) {
    /**
     * ARN of the listener.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date and time that the listener was created, specified in ISO-8601 format.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Default action block for the default listener rule. Default action blocks are defined below.
     */
    public val defaultAction: Output<ListenerDefaultAction>
        get() = javaResource.defaultAction().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    public val lastUpdatedAt: Output<String>
        get() = javaResource.lastUpdatedAt().applyValue({ args0 -> args0 })

    /**
     * Standalone ID of the listener, e.g. `listener-0a1b2c3d4e5f6g`.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * Name of the listener. A listener name must be unique within a service. Valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Listener port. You can specify a value from 1 to 65535. If `port` is not specified and `protocol` is HTTP, the value will default to 80. If `port` is not specified and `protocol` is HTTPS, the value will default to 443.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Protocol for the listener. Supported values are `HTTP`, `HTTPS` or `TLS_PASSTHROUGH`
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     */
    public val serviceArn: Output<String>
        get() = javaResource.serviceArn().applyValue({ args0 -> args0 })

    /**
     * ID of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     * > **NOTE:** You must specify one of the following arguments: `service_arn` or `service_identifier`.
     */
    public val serviceIdentifier: Output<String>
        get() = javaResource.serviceIdentifier().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ListenerMapper : ResourceMapper<Listener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.Listener::class == javaResource::class

    override fun map(javaResource: Resource): Listener = Listener(
        javaResource as
            com.pulumi.aws.vpclattice.Listener,
    )
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Listener].
 */
public suspend fun listener(name: String, block: suspend ListenerResourceBuilder.() -> Unit): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listener(name: String): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
