@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleAction
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleMatch
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleAction.Companion.toKotlin as listenerRuleActionToKotlin
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleMatch.Companion.toKotlin as listenerRuleMatchToKotlin

/**
 * Builder for [ListenerRule].
 */
@PulumiTagMarker
public class ListenerRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerRuleArgs = ListenerRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerRuleArgsBuilder.() -> Unit) {
        val builder = ListenerRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ListenerRule {
        val builtJavaResource = com.pulumi.aws.vpclattice.ListenerRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ListenerRule(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Listener Rule.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.vpclattice.ListenerRule("test", {
 *     name: "example",
 *     listenerIdentifier: exampleAwsVpclatticeListener.listenerId,
 *     serviceIdentifier: exampleAwsVpclatticeService.id,
 *     priority: 20,
 *     match: {
 *         httpMatch: {
 *             headerMatches: [{
 *                 name: "example-header",
 *                 caseSensitive: false,
 *                 match: {
 *                     exact: "example-contains",
 *                 },
 *             }],
 *             pathMatch: {
 *                 caseSensitive: true,
 *                 match: {
 *                     prefix: "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action: {
 *         forward: {
 *             targetGroups: [
 *                 {
 *                     targetGroupIdentifier: example.id,
 *                     weight: 1,
 *                 },
 *                 {
 *                     targetGroupIdentifier: example2.id,
 *                     weight: 2,
 *                 },
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.vpclattice.ListenerRule("test",
 *     name="example",
 *     listener_identifier=example_aws_vpclattice_listener["listenerId"],
 *     service_identifier=example_aws_vpclattice_service["id"],
 *     priority=20,
 *     match={
 *         "http_match": {
 *             "header_matches": [{
 *                 "name": "example-header",
 *                 "case_sensitive": False,
 *                 "match": {
 *                     "exact": "example-contains",
 *                 },
 *             }],
 *             "path_match": {
 *                 "case_sensitive": True,
 *                 "match": {
 *                     "prefix": "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action={
 *         "forward": {
 *             "target_groups": [
 *                 {
 *                     "target_group_identifier": example["id"],
 *                     "weight": 1,
 *                 },
 *                 {
 *                     "target_group_identifier": example2["id"],
 *                     "weight": 2,
 *                 },
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.VpcLattice.ListenerRule("test", new()
 *     {
 *         Name = "example",
 *         ListenerIdentifier = exampleAwsVpclatticeListener.ListenerId,
 *         ServiceIdentifier = exampleAwsVpclatticeService.Id,
 *         Priority = 20,
 *         Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchArgs
 *         {
 *             HttpMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchArgs
 *             {
 *                 HeaderMatches = new[]
 *                 {
 *                     new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchHeaderMatchArgs
 *                     {
 *                         Name = "example-header",
 *                         CaseSensitive = false,
 *                         Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs
 *                         {
 *                             Exact = "example-contains",
 *                         },
 *                     },
 *                 },
 *                 PathMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchArgs
 *                 {
 *                     CaseSensitive = true,
 *                     Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs
 *                     {
 *                         Prefix = "/example-path",
 *                     },
 *                 },
 *             },
 *         },
 *         Action = new Aws.VpcLattice.Inputs.ListenerRuleActionArgs
 *         {
 *             Forward = new Aws.VpcLattice.Inputs.ListenerRuleActionForwardArgs
 *             {
 *                 TargetGroups = new[]
 *                 {
 *                     new Aws.VpcLattice.Inputs.ListenerRuleActionForwardTargetGroupArgs
 *                     {
 *                         TargetGroupIdentifier = example.Id,
 *                         Weight = 1,
 *                     },
 *                     new Aws.VpcLattice.Inputs.ListenerRuleActionForwardTargetGroupArgs
 *                     {
 *                         TargetGroupIdentifier = example2.Id,
 *                         Weight = 2,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewListenerRule(ctx, "test", &vpclattice.ListenerRuleArgs{
 * 			Name:               pulumi.String("example"),
 * 			ListenerIdentifier: pulumi.Any(exampleAwsVpclatticeListener.ListenerId),
 * 			ServiceIdentifier:  pulumi.Any(exampleAwsVpclatticeService.Id),
 * 			Priority:           pulumi.Int(20),
 * 			Match: &vpclattice.ListenerRuleMatchArgs{
 * 				HttpMatch: &vpclattice.ListenerRuleMatchHttpMatchArgs{
 * 					HeaderMatches: vpclattice.ListenerRuleMatchHttpMatchHeaderMatchArray{
 * 						&vpclattice.ListenerRuleMatchHttpMatchHeaderMatchArgs{
 * 							Name:          pulumi.String("example-header"),
 * 							CaseSensitive: pulumi.Bool(false),
 * 							Match: &vpclattice.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs{
 * 								Exact: pulumi.String("example-contains"),
 * 							},
 * 						},
 * 					},
 * 					PathMatch: &vpclattice.ListenerRuleMatchHttpMatchPathMatchArgs{
 * 						CaseSensitive: pulumi.Bool(true),
 * 						Match: &vpclattice.ListenerRuleMatchHttpMatchPathMatchMatchArgs{
 * 							Prefix: pulumi.String("/example-path"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Action: &vpclattice.ListenerRuleActionArgs{
 * 				Forward: &vpclattice.ListenerRuleActionForwardArgs{
 * 					TargetGroups: vpclattice.ListenerRuleActionForwardTargetGroupArray{
 * 						&vpclattice.ListenerRuleActionForwardTargetGroupArgs{
 * 							TargetGroupIdentifier: pulumi.Any(example.Id),
 * 							Weight:                pulumi.Int(1),
 * 						},
 * 						&vpclattice.ListenerRuleActionForwardTargetGroupArgs{
 * 							TargetGroupIdentifier: pulumi.Any(example2.Id),
 * 							Weight:                pulumi.Int(2),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .name("example")
 *             .listenerIdentifier(exampleAwsVpclatticeListener.listenerId())
 *             .serviceIdentifier(exampleAwsVpclatticeService.id())
 *             .priority(20)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .headerMatches(ListenerRuleMatchHttpMatchHeaderMatchArgs.builder()
 *                         .name("example-header")
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchHeaderMatchMatchArgs.builder()
 *                             .exact("example-contains")
 *                             .build())
 *                         .build())
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(true)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .prefix("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .forward(ListenerRuleActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example.id())
 *                             .weight(1)
 *                             .build(),
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example2.id())
 *                             .weight(2)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:vpclattice:ListenerRule
 *     properties:
 *       name: example
 *       listenerIdentifier: ${exampleAwsVpclatticeListener.listenerId}
 *       serviceIdentifier: ${exampleAwsVpclatticeService.id}
 *       priority: 20
 *       match:
 *         httpMatch:
 *           headerMatches:
 *             - name: example-header
 *               caseSensitive: false
 *               match:
 *                 exact: example-contains
 *           pathMatch:
 *             caseSensitive: true
 *             match:
 *               prefix: /example-path
 *       action:
 *         forward:
 *           targetGroups:
 *             - targetGroupIdentifier: ${example.id}
 *               weight: 1
 *             - targetGroupIdentifier: ${example2.id}
 *               weight: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.vpclattice.ListenerRule("test", {
 *     name: "example",
 *     listenerIdentifier: example.listenerId,
 *     serviceIdentifier: exampleAwsVpclatticeService.id,
 *     priority: 10,
 *     match: {
 *         httpMatch: {
 *             pathMatch: {
 *                 caseSensitive: false,
 *                 match: {
 *                     exact: "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action: {
 *         fixedResponse: {
 *             statusCode: 404,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.vpclattice.ListenerRule("test",
 *     name="example",
 *     listener_identifier=example["listenerId"],
 *     service_identifier=example_aws_vpclattice_service["id"],
 *     priority=10,
 *     match={
 *         "http_match": {
 *             "path_match": {
 *                 "case_sensitive": False,
 *                 "match": {
 *                     "exact": "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action={
 *         "fixed_response": {
 *             "status_code": 404,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.VpcLattice.ListenerRule("test", new()
 *     {
 *         Name = "example",
 *         ListenerIdentifier = example.ListenerId,
 *         ServiceIdentifier = exampleAwsVpclatticeService.Id,
 *         Priority = 10,
 *         Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchArgs
 *         {
 *             HttpMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchArgs
 *             {
 *                 PathMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchArgs
 *                 {
 *                     CaseSensitive = false,
 *                     Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs
 *                     {
 *                         Exact = "/example-path",
 *                     },
 *                 },
 *             },
 *         },
 *         Action = new Aws.VpcLattice.Inputs.ListenerRuleActionArgs
 *         {
 *             FixedResponse = new Aws.VpcLattice.Inputs.ListenerRuleActionFixedResponseArgs
 *             {
 *                 StatusCode = 404,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewListenerRule(ctx, "test", &vpclattice.ListenerRuleArgs{
 * 			Name:               pulumi.String("example"),
 * 			ListenerIdentifier: pulumi.Any(example.ListenerId),
 * 			ServiceIdentifier:  pulumi.Any(exampleAwsVpclatticeService.Id),
 * 			Priority:           pulumi.Int(10),
 * 			Match: &vpclattice.ListenerRuleMatchArgs{
 * 				HttpMatch: &vpclattice.ListenerRuleMatchHttpMatchArgs{
 * 					PathMatch: &vpclattice.ListenerRuleMatchHttpMatchPathMatchArgs{
 * 						CaseSensitive: pulumi.Bool(false),
 * 						Match: &vpclattice.ListenerRuleMatchHttpMatchPathMatchMatchArgs{
 * 							Exact: pulumi.String("/example-path"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Action: &vpclattice.ListenerRuleActionArgs{
 * 				FixedResponse: &vpclattice.ListenerRuleActionFixedResponseArgs{
 * 					StatusCode: pulumi.Int(404),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .name("example")
 *             .listenerIdentifier(example.listenerId())
 *             .serviceIdentifier(exampleAwsVpclatticeService.id())
 *             .priority(10)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .exact("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .fixedResponse(ListenerRuleActionFixedResponseArgs.builder()
 *                     .statusCode(404)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:vpclattice:ListenerRule
 *     properties:
 *       name: example
 *       listenerIdentifier: ${example.listenerId}
 *       serviceIdentifier: ${exampleAwsVpclatticeService.id}
 *       priority: 10
 *       match:
 *         httpMatch:
 *           pathMatch:
 *             caseSensitive: false
 *             match:
 *               exact: /example-path
 *       action:
 *         fixedResponse:
 *           statusCode: 404
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Listener Rule using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/listenerRule:ListenerRule example service123/listener456/rule789
 * ```
 */
public class ListenerRule internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.ListenerRule,
) : KotlinCustomResource(javaResource, ListenerRuleMapper) {
    /**
     * The action for the listener rule.
     */
    public val action: Output<ListenerRuleAction>
        get() = javaResource.action().applyValue({ args0 ->
            args0.let({ args0 ->
                listenerRuleActionToKotlin(args0)
            })
        })

    /**
     * The ARN for the listener rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Name (ARN) of the listener.
     */
    public val listenerIdentifier: Output<String>
        get() = javaResource.listenerIdentifier().applyValue({ args0 -> args0 })

    /**
     * The rule match.
     */
    public val match: Output<ListenerRuleMatch>
        get() = javaResource.match().applyValue({ args0 ->
            args0.let({ args0 ->
                listenerRuleMatchToKotlin(args0)
            })
        })

    /**
     * The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * The following arguments are optional:
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the listener rule.
     */
    public val ruleId: Output<String>
        get() = javaResource.ruleId().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Identifier (ARN) of the service.
     */
    public val serviceIdentifier: Output<String>
        get() = javaResource.serviceIdentifier().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ListenerRuleMapper : ResourceMapper<ListenerRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.ListenerRule::class == javaResource::class

    override fun map(javaResource: Resource): ListenerRule = ListenerRule(
        javaResource as
            com.pulumi.aws.vpclattice.ListenerRule,
    )
}

/**
 * @see [ListenerRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerRule].
 */
public suspend fun listenerRule(
    name: String,
    block: suspend ListenerRuleResourceBuilder.() -> Unit,
): ListenerRule {
    val builder = ListenerRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerRule(name: String): ListenerRule {
    val builder = ListenerRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
