@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ListenerRuleArgs.builder
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleActionArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleActionArgsBuilder
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleMatchArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleMatchArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Listener Rule.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.vpclattice.ListenerRule("test", {
 *     name: "example",
 *     listenerIdentifier: exampleAwsVpclatticeListener.listenerId,
 *     serviceIdentifier: exampleAwsVpclatticeService.id,
 *     priority: 20,
 *     match: {
 *         httpMatch: {
 *             headerMatches: [{
 *                 name: "example-header",
 *                 caseSensitive: false,
 *                 match: {
 *                     exact: "example-contains",
 *                 },
 *             }],
 *             pathMatch: {
 *                 caseSensitive: true,
 *                 match: {
 *                     prefix: "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action: {
 *         forward: {
 *             targetGroups: [
 *                 {
 *                     targetGroupIdentifier: example.id,
 *                     weight: 1,
 *                 },
 *                 {
 *                     targetGroupIdentifier: example2.id,
 *                     weight: 2,
 *                 },
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.vpclattice.ListenerRule("test",
 *     name="example",
 *     listener_identifier=example_aws_vpclattice_listener["listenerId"],
 *     service_identifier=example_aws_vpclattice_service["id"],
 *     priority=20,
 *     match={
 *         "http_match": {
 *             "header_matches": [{
 *                 "name": "example-header",
 *                 "case_sensitive": False,
 *                 "match": {
 *                     "exact": "example-contains",
 *                 },
 *             }],
 *             "path_match": {
 *                 "case_sensitive": True,
 *                 "match": {
 *                     "prefix": "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action={
 *         "forward": {
 *             "target_groups": [
 *                 {
 *                     "target_group_identifier": example["id"],
 *                     "weight": 1,
 *                 },
 *                 {
 *                     "target_group_identifier": example2["id"],
 *                     "weight": 2,
 *                 },
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.VpcLattice.ListenerRule("test", new()
 *     {
 *         Name = "example",
 *         ListenerIdentifier = exampleAwsVpclatticeListener.ListenerId,
 *         ServiceIdentifier = exampleAwsVpclatticeService.Id,
 *         Priority = 20,
 *         Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchArgs
 *         {
 *             HttpMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchArgs
 *             {
 *                 HeaderMatches = new[]
 *                 {
 *                     new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchHeaderMatchArgs
 *                     {
 *                         Name = "example-header",
 *                         CaseSensitive = false,
 *                         Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs
 *                         {
 *                             Exact = "example-contains",
 *                         },
 *                     },
 *                 },
 *                 PathMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchArgs
 *                 {
 *                     CaseSensitive = true,
 *                     Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs
 *                     {
 *                         Prefix = "/example-path",
 *                     },
 *                 },
 *             },
 *         },
 *         Action = new Aws.VpcLattice.Inputs.ListenerRuleActionArgs
 *         {
 *             Forward = new Aws.VpcLattice.Inputs.ListenerRuleActionForwardArgs
 *             {
 *                 TargetGroups = new[]
 *                 {
 *                     new Aws.VpcLattice.Inputs.ListenerRuleActionForwardTargetGroupArgs
 *                     {
 *                         TargetGroupIdentifier = example.Id,
 *                         Weight = 1,
 *                     },
 *                     new Aws.VpcLattice.Inputs.ListenerRuleActionForwardTargetGroupArgs
 *                     {
 *                         TargetGroupIdentifier = example2.Id,
 *                         Weight = 2,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewListenerRule(ctx, "test", &vpclattice.ListenerRuleArgs{
 * 			Name:               pulumi.String("example"),
 * 			ListenerIdentifier: pulumi.Any(exampleAwsVpclatticeListener.ListenerId),
 * 			ServiceIdentifier:  pulumi.Any(exampleAwsVpclatticeService.Id),
 * 			Priority:           pulumi.Int(20),
 * 			Match: &vpclattice.ListenerRuleMatchArgs{
 * 				HttpMatch: &vpclattice.ListenerRuleMatchHttpMatchArgs{
 * 					HeaderMatches: vpclattice.ListenerRuleMatchHttpMatchHeaderMatchArray{
 * 						&vpclattice.ListenerRuleMatchHttpMatchHeaderMatchArgs{
 * 							Name:          pulumi.String("example-header"),
 * 							CaseSensitive: pulumi.Bool(false),
 * 							Match: &vpclattice.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs{
 * 								Exact: pulumi.String("example-contains"),
 * 							},
 * 						},
 * 					},
 * 					PathMatch: &vpclattice.ListenerRuleMatchHttpMatchPathMatchArgs{
 * 						CaseSensitive: pulumi.Bool(true),
 * 						Match: &vpclattice.ListenerRuleMatchHttpMatchPathMatchMatchArgs{
 * 							Prefix: pulumi.String("/example-path"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Action: &vpclattice.ListenerRuleActionArgs{
 * 				Forward: &vpclattice.ListenerRuleActionForwardArgs{
 * 					TargetGroups: vpclattice.ListenerRuleActionForwardTargetGroupArray{
 * 						&vpclattice.ListenerRuleActionForwardTargetGroupArgs{
 * 							TargetGroupIdentifier: pulumi.Any(example.Id),
 * 							Weight:                pulumi.Int(1),
 * 						},
 * 						&vpclattice.ListenerRuleActionForwardTargetGroupArgs{
 * 							TargetGroupIdentifier: pulumi.Any(example2.Id),
 * 							Weight:                pulumi.Int(2),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .name("example")
 *             .listenerIdentifier(exampleAwsVpclatticeListener.listenerId())
 *             .serviceIdentifier(exampleAwsVpclatticeService.id())
 *             .priority(20)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .headerMatches(ListenerRuleMatchHttpMatchHeaderMatchArgs.builder()
 *                         .name("example-header")
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchHeaderMatchMatchArgs.builder()
 *                             .exact("example-contains")
 *                             .build())
 *                         .build())
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(true)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .prefix("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .forward(ListenerRuleActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example.id())
 *                             .weight(1)
 *                             .build(),
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example2.id())
 *                             .weight(2)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:vpclattice:ListenerRule
 *     properties:
 *       name: example
 *       listenerIdentifier: ${exampleAwsVpclatticeListener.listenerId}
 *       serviceIdentifier: ${exampleAwsVpclatticeService.id}
 *       priority: 20
 *       match:
 *         httpMatch:
 *           headerMatches:
 *             - name: example-header
 *               caseSensitive: false
 *               match:
 *                 exact: example-contains
 *           pathMatch:
 *             caseSensitive: true
 *             match:
 *               prefix: /example-path
 *       action:
 *         forward:
 *           targetGroups:
 *             - targetGroupIdentifier: ${example.id}
 *               weight: 1
 *             - targetGroupIdentifier: ${example2.id}
 *               weight: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.vpclattice.ListenerRule("test", {
 *     name: "example",
 *     listenerIdentifier: example.listenerId,
 *     serviceIdentifier: exampleAwsVpclatticeService.id,
 *     priority: 10,
 *     match: {
 *         httpMatch: {
 *             pathMatch: {
 *                 caseSensitive: false,
 *                 match: {
 *                     exact: "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action: {
 *         fixedResponse: {
 *             statusCode: 404,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.vpclattice.ListenerRule("test",
 *     name="example",
 *     listener_identifier=example["listenerId"],
 *     service_identifier=example_aws_vpclattice_service["id"],
 *     priority=10,
 *     match={
 *         "http_match": {
 *             "path_match": {
 *                 "case_sensitive": False,
 *                 "match": {
 *                     "exact": "/example-path",
 *                 },
 *             },
 *         },
 *     },
 *     action={
 *         "fixed_response": {
 *             "status_code": 404,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.VpcLattice.ListenerRule("test", new()
 *     {
 *         Name = "example",
 *         ListenerIdentifier = example.ListenerId,
 *         ServiceIdentifier = exampleAwsVpclatticeService.Id,
 *         Priority = 10,
 *         Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchArgs
 *         {
 *             HttpMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchArgs
 *             {
 *                 PathMatch = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchArgs
 *                 {
 *                     CaseSensitive = false,
 *                     Match = new Aws.VpcLattice.Inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs
 *                     {
 *                         Exact = "/example-path",
 *                     },
 *                 },
 *             },
 *         },
 *         Action = new Aws.VpcLattice.Inputs.ListenerRuleActionArgs
 *         {
 *             FixedResponse = new Aws.VpcLattice.Inputs.ListenerRuleActionFixedResponseArgs
 *             {
 *                 StatusCode = 404,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewListenerRule(ctx, "test", &vpclattice.ListenerRuleArgs{
 * 			Name:               pulumi.String("example"),
 * 			ListenerIdentifier: pulumi.Any(example.ListenerId),
 * 			ServiceIdentifier:  pulumi.Any(exampleAwsVpclatticeService.Id),
 * 			Priority:           pulumi.Int(10),
 * 			Match: &vpclattice.ListenerRuleMatchArgs{
 * 				HttpMatch: &vpclattice.ListenerRuleMatchHttpMatchArgs{
 * 					PathMatch: &vpclattice.ListenerRuleMatchHttpMatchPathMatchArgs{
 * 						CaseSensitive: pulumi.Bool(false),
 * 						Match: &vpclattice.ListenerRuleMatchHttpMatchPathMatchMatchArgs{
 * 							Exact: pulumi.String("/example-path"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Action: &vpclattice.ListenerRuleActionArgs{
 * 				FixedResponse: &vpclattice.ListenerRuleActionFixedResponseArgs{
 * 					StatusCode: pulumi.Int(404),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .name("example")
 *             .listenerIdentifier(example.listenerId())
 *             .serviceIdentifier(exampleAwsVpclatticeService.id())
 *             .priority(10)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .exact("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .fixedResponse(ListenerRuleActionFixedResponseArgs.builder()
 *                     .statusCode(404)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:vpclattice:ListenerRule
 *     properties:
 *       name: example
 *       listenerIdentifier: ${example.listenerId}
 *       serviceIdentifier: ${exampleAwsVpclatticeService.id}
 *       priority: 10
 *       match:
 *         httpMatch:
 *           pathMatch:
 *             caseSensitive: false
 *             match:
 *               exact: /example-path
 *       action:
 *         fixedResponse:
 *           statusCode: 404
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Listener Rule using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/listenerRule:ListenerRule example service123/listener456/rule789
 * ```
 * @property action The action for the listener rule.
 * @property listenerIdentifier The ID or Amazon Resource Name (ARN) of the listener.
 * @property match The rule match.
 * @property name The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
 * @property priority The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
 * The following arguments are optional:
 * @property serviceIdentifier The ID or Amazon Resource Identifier (ARN) of the service.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ListenerRuleArgs(
    public val action: Output<ListenerRuleActionArgs>? = null,
    public val listenerIdentifier: Output<String>? = null,
    public val match: Output<ListenerRuleMatchArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val serviceIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ListenerRuleArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ListenerRuleArgs =
        com.pulumi.aws.vpclattice.ListenerRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .listenerIdentifier(listenerIdentifier?.applyValue({ args0 -> args0 }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .serviceIdentifier(serviceIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ListenerRuleArgs].
 */
@PulumiTagMarker
public class ListenerRuleArgsBuilder internal constructor() {
    private var action: Output<ListenerRuleActionArgs>? = null

    private var listenerIdentifier: Output<String>? = null

    private var match: Output<ListenerRuleMatchArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var serviceIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The action for the listener rule.
     */
    @JvmName("dokasrfjwlcmeoge")
    public suspend fun action(`value`: Output<ListenerRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the listener.
     */
    @JvmName("fsbnrcypskusvnvn")
    public suspend fun listenerIdentifier(`value`: Output<String>) {
        this.listenerIdentifier = value
    }

    /**
     * @param value The rule match.
     */
    @JvmName("uaustuuhuqenjlhb")
    public suspend fun match(`value`: Output<ListenerRuleMatchArgs>) {
        this.match = value
    }

    /**
     * @param value The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("xpiuhlkravafkysy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * The following arguments are optional:
     */
    @JvmName("nddxqpofmxvptdyd")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service.
     */
    @JvmName("lmwnufjoteyosgaw")
    public suspend fun serviceIdentifier(`value`: Output<String>) {
        this.serviceIdentifier = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("owgsqwnweurmabil")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The action for the listener rule.
     */
    @JvmName("arcacaasbkjwyfyq")
    public suspend fun action(`value`: ListenerRuleActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action for the listener rule.
     */
    @JvmName("myfgqexidxacwref")
    public suspend fun action(argument: suspend ListenerRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the listener.
     */
    @JvmName("mlkaftpjiluddtru")
    public suspend fun listenerIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerIdentifier = mapped
    }

    /**
     * @param value The rule match.
     */
    @JvmName("irxbgunkhlkmmftv")
    public suspend fun match(`value`: ListenerRuleMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument The rule match.
     */
    @JvmName("bqnyncqjhmvdcfbb")
    public suspend fun match(argument: suspend ListenerRuleMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("colbrplpnrdwrord")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * The following arguments are optional:
     */
    @JvmName("tnkeoknlqklhlilv")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service.
     */
    @JvmName("lxbpagfrbqjlaxsu")
    public suspend fun serviceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceIdentifier = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jlgqsthgyxkxgivw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bahaginjlbxehgrk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ListenerRuleArgs = ListenerRuleArgs(
        action = action,
        listenerIdentifier = listenerIdentifier,
        match = match,
        name = name,
        priority = priority,
        serviceIdentifier = serviceIdentifier,
        tags = tags,
    )
}
