@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Resource Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const currentGetPartition = aws.getPartition({});
 * const example = new aws.vpclattice.ServiceNetwork("example", {name: "example-vpclattice-service-network"});
 * const exampleResourcePolicy = new aws.vpclattice.ResourcePolicy("example", {
 *     resourceArn: example.arn,
 *     policy: pulumi.jsonStringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "test-pol-principals-6",
 *             Effect: "Allow",
 *             Principal: {
 *                 AWS: Promise.all([currentGetPartition, current])&#46;then(([currentGetPartition, current]) => `arn:${currentGetPartition.partition}:iam::${current.accountId}:root`),
 *             },
 *             Action: [
 *                 "vpc-lattice:CreateServiceNetworkVpcAssociation",
 *                 "vpc-lattice:CreateServiceNetworkServiceAssociation",
 *                 "vpc-lattice:GetServiceNetwork",
 *             ],
 *             Resource: example.arn,
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * current_get_partition = aws.get_partition()
 * example = aws.vpclattice.ServiceNetwork("example", name="example-vpclattice-service-network")
 * example_resource_policy = aws.vpclattice.ResourcePolicy("example",
 *     resource_arn=example.arn,
 *     policy=pulumi.Output.json_dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "test-pol-principals-6",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
 *             },
 *             "Action": [
 *                 "vpc-lattice:CreateServiceNetworkVpcAssociation",
 *                 "vpc-lattice:CreateServiceNetworkServiceAssociation",
 *                 "vpc-lattice:GetServiceNetwork",
 *             ],
 *             "Resource": example.arn,
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var currentGetPartition = Aws.GetPartition.Invoke();
 *     var example = new Aws.VpcLattice.ServiceNetwork("example", new()
 *     {
 *         Name = "example-vpclattice-service-network",
 *     });
 *     var exampleResourcePolicy = new Aws.VpcLattice.ResourcePolicy("example", new()
 *     {
 *         ResourceArn = example.Arn,
 *         Policy = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "test-pol-principals-6",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = Output.Tuple(currentGetPartition, current).Apply(values =>
 *                         {
 *                             var currentGetPartition = values.Item1;
 *                             var current = values.Item2;
 *                             return $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root";
 *                         }),
 *                     },
 *                     ["Action"] = new[]
 *                     {
 *                         "vpc-lattice:CreateServiceNetworkVpcAssociation",
 *                         "vpc-lattice:CreateServiceNetworkServiceAssociation",
 *                         "vpc-lattice:GetServiceNetwork",
 *                     },
 *                     ["Resource"] = example.Arn,
 *                 },
 *             },
 *         })),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetPartition, err := aws.GetPartition(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpclattice.NewServiceNetwork(ctx, "example", &vpclattice.ServiceNetworkArgs{
 * 			Name: pulumi.String("example-vpclattice-service-network"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpclattice.NewResourcePolicy(ctx, "example", &vpclattice.ResourcePolicyArgs{
 * 			ResourceArn: example.Arn,
 * 			Policy: example.Arn.ApplyT(func(arn string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 					"Version": "2012-10-17",
 * 					"Statement": []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"Sid":    "test-pol-principals-6",
 * 							"Effect": "Allow",
 * 							"Principal": map[string]interface{}{
 * 								"AWS": fmt.Sprintf("arn:%v:iam::%v:root", currentGetPartition.Partition, current.AccountId),
 * 							},
 * 							"Action": []string{
 * 								"vpc-lattice:CreateServiceNetworkVpcAssociation",
 * 								"vpc-lattice:CreateServiceNetworkServiceAssociation",
 * 								"vpc-lattice:GetServiceNetwork",
 * 							},
 * 							"Resource": arn,
 * 						},
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return pulumi.String(json0), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.vpclattice.ServiceNetwork;
 * import com.pulumi.aws.vpclattice.ServiceNetworkArgs;
 * import com.pulumi.aws.vpclattice.ResourcePolicy;
 * import com.pulumi.aws.vpclattice.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var currentGetPartition = AwsFunctions.getPartition();
 *         var example = new ServiceNetwork("example", ServiceNetworkArgs.builder()
 *             .name("example-vpclattice-service-network")
 *             .build());
 *         var exampleResourcePolicy = new ResourcePolicy("exampleResourcePolicy", ResourcePolicyArgs.builder()
 *             .resourceArn(example.arn())
 *             .policy(example.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "test-pol-principals-6"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray(
 *                             "vpc-lattice:CreateServiceNetworkVpcAssociation",
 *                             "vpc-lattice:CreateServiceNetworkServiceAssociation",
 *                             "vpc-lattice:GetServiceNetwork"
 *                         )),
 *                         jsonProperty("Resource", arn)
 *                     )))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:ServiceNetwork
 *     properties:
 *       name: example-vpclattice-service-network
 *   exampleResourcePolicy:
 *     type: aws:vpclattice:ResourcePolicy
 *     name: example
 *     properties:
 *       resourceArn: ${example.arn}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid: test-pol-principals-6
 *               Effect: Allow
 *               Principal:
 *                 AWS: arn:${currentGetPartition.partition}:iam::${current.accountId}:root
 *               Action:
 *                 - vpc-lattice:CreateServiceNetworkVpcAssociation
 *                 - vpc-lattice:CreateServiceNetworkServiceAssociation
 *                 - vpc-lattice:GetServiceNetwork
 *               Resource: ${example.arn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetPartition:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Resource Policy using the `resource_arn`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/resourcePolicy:ResourcePolicy example rft-8012925589
 * ```
 * @property policy An IAM policy. The policy string in JSON must not contain newlines or blank lines.
 * @property resourceArn The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ResourcePolicyArgs =
        com.pulumi.aws.vpclattice.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value An IAM policy. The policy string in JSON must not contain newlines or blank lines.
     */
    @JvmName("hdesqwdokvrekhou")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    @JvmName("ukdraujeiassvptg")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value An IAM policy. The policy string in JSON must not contain newlines or blank lines.
     */
    @JvmName("jbgeeswupomlkhya")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    @JvmName("vxsllcsaghlhsvrq")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
