@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.ServiceDnsEntry
import com.pulumi.aws.vpclattice.kotlin.outputs.ServiceDnsEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.aws.vpclattice.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Service.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.Service("example", {
 *     name: "example",
 *     authType: "AWS_IAM",
 *     customDomainName: "example.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.Service("example",
 *     name="example",
 *     auth_type="AWS_IAM",
 *     custom_domain_name="example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.Service("example", new()
 *     {
 *         Name = "example",
 *         AuthType = "AWS_IAM",
 *         CustomDomainName = "example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewService(ctx, "example", &vpclattice.ServiceArgs{
 * 			Name:             pulumi.String("example"),
 * 			AuthType:         pulumi.String("AWS_IAM"),
 * 			CustomDomainName: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .authType("AWS_IAM")
 *             .customDomainName("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:Service
 *     properties:
 *       name: example
 *       authType: AWS_IAM
 *       customDomainName: example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Service using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/service:Service example svc-06728e2357ea55f8a
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * ARN of the service.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Type of IAM policy. Either `NONE` or `AWS_IAM`.
     */
    public val authType: Output<String>
        get() = javaResource.authType().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the certificate.
     */
    public val certificateArn: Output<String>?
        get() = javaResource.certificateArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Custom domain name of the service.
     */
    public val customDomainName: Output<String>?
        get() = javaResource.customDomainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DNS name of the service.
     */
    public val dnsEntries: Output<List<ServiceDnsEntry>>
        get() = javaResource.dnsEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Name of the service. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.Must be between 3 and 40 characters in length.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Status of the service.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.aws.vpclattice.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
