@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Service.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.Service("example", {
 *     name: "example",
 *     authType: "AWS_IAM",
 *     customDomainName: "example.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.Service("example",
 *     name="example",
 *     auth_type="AWS_IAM",
 *     custom_domain_name="example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.Service("example", new()
 *     {
 *         Name = "example",
 *         AuthType = "AWS_IAM",
 *         CustomDomainName = "example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewService(ctx, "example", &vpclattice.ServiceArgs{
 * 			Name:             pulumi.String("example"),
 * 			AuthType:         pulumi.String("AWS_IAM"),
 * 			CustomDomainName: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .name("example")
 *             .authType("AWS_IAM")
 *             .customDomainName("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:Service
 *     properties:
 *       name: example
 *       authType: AWS_IAM
 *       customDomainName: example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Service using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/service:Service example svc-06728e2357ea55f8a
 * ```
 * @property authType Type of IAM policy. Either `NONE` or `AWS_IAM`.
 * @property certificateArn Amazon Resource Name (ARN) of the certificate.
 * @property customDomainName Custom domain name of the service.
 * @property name Name of the service. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.Must be between 3 and 40 characters in length.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ServiceArgs(
    public val authType: Output<String>? = null,
    public val certificateArn: Output<String>? = null,
    public val customDomainName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ServiceArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ServiceArgs =
        com.pulumi.aws.vpclattice.ServiceArgs.builder()
            .authType(authType?.applyValue({ args0 -> args0 }))
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .customDomainName(customDomainName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var certificateArn: Output<String>? = null

    private var customDomainName: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Type of IAM policy. Either `NONE` or `AWS_IAM`.
     */
    @JvmName("qjkqtlhqmomriawl")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the certificate.
     */
    @JvmName("uonfridcjdwxxsgj")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value Custom domain name of the service.
     */
    @JvmName("gtwslsautnmhxgxl")
    public suspend fun customDomainName(`value`: Output<String>) {
        this.customDomainName = value
    }

    /**
     * @param value Name of the service. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.Must be between 3 and 40 characters in length.
     * The following arguments are optional:
     */
    @JvmName("etiefhkohxrijaqd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hxvlwqqnnktxdypx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of IAM policy. Either `NONE` or `AWS_IAM`.
     */
    @JvmName("qfqlupiexiwhfcps")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the certificate.
     */
    @JvmName("hcbwxpytqydrwrwb")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value Custom domain name of the service.
     */
    @JvmName("uyahrqwhhikmxdor")
    public suspend fun customDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomainName = mapped
    }

    /**
     * @param value Name of the service. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.Must be between 3 and 40 characters in length.
     * The following arguments are optional:
     */
    @JvmName("wnajqoqxrtongewb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("euwxmtxiqrlxedbg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rgipjtxsvcsqjeau")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        authType = authType,
        certificateArn = certificateArn,
        customDomainName = customDomainName,
        name = name,
        tags = tags,
    )
}
