@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceNetwork].
 */
@PulumiTagMarker
public class ServiceNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceNetworkArgs = ServiceNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceNetworkArgsBuilder.() -> Unit) {
        val builder = ServiceNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceNetwork {
        val builtJavaResource = com.pulumi.aws.vpclattice.ServiceNetwork(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceNetwork(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Service Network.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.ServiceNetwork("example", {
 *     name: "example",
 *     authType: "AWS_IAM",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.ServiceNetwork("example",
 *     name="example",
 *     auth_type="AWS_IAM")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.ServiceNetwork("example", new()
 *     {
 *         Name = "example",
 *         AuthType = "AWS_IAM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewServiceNetwork(ctx, "example", &vpclattice.ServiceNetworkArgs{
 * 			Name:     pulumi.String("example"),
 * 			AuthType: pulumi.String("AWS_IAM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ServiceNetwork;
 * import com.pulumi.aws.vpclattice.ServiceNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceNetwork("example", ServiceNetworkArgs.builder()
 *             .name("example")
 *             .authType("AWS_IAM")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:ServiceNetwork
 *     properties:
 *       name: example
 *       authType: AWS_IAM
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Service Network using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/serviceNetwork:ServiceNetwork example sn-0158f91c1e3358dba
 * ```
 */
public class ServiceNetwork internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.ServiceNetwork,
) : KotlinCustomResource(javaResource, ServiceNetworkMapper) {
    /**
     * ARN of the Service Network.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Type of IAM policy. Either `NONE` or `AWS_IAM`.
     */
    public val authType: Output<String>
        get() = javaResource.authType().applyValue({ args0 -> args0 })

    /**
     * Name of the service network
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ServiceNetworkMapper : ResourceMapper<ServiceNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.ServiceNetwork::class == javaResource::class

    override fun map(javaResource: Resource): ServiceNetwork = ServiceNetwork(
        javaResource as
            com.pulumi.aws.vpclattice.ServiceNetwork,
    )
}

/**
 * @see [ServiceNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceNetwork].
 */
public suspend fun serviceNetwork(
    name: String,
    block: suspend ServiceNetworkResourceBuilder.() -> Unit,
): ServiceNetwork {
    val builder = ServiceNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceNetwork(name: String): ServiceNetwork {
    val builder = ServiceNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
