@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.ServiceNetworkServiceAssociationDnsEntry
import com.pulumi.aws.vpclattice.kotlin.outputs.ServiceNetworkServiceAssociationDnsEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ServiceNetworkServiceAssociation].
 */
@PulumiTagMarker
public class ServiceNetworkServiceAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceNetworkServiceAssociationArgs = ServiceNetworkServiceAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceNetworkServiceAssociationArgsBuilder.() -> Unit) {
        val builder = ServiceNetworkServiceAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceNetworkServiceAssociation {
        val builtJavaResource =
            com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceNetworkServiceAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Service Network Service Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.ServiceNetworkServiceAssociation("example", {
 *     serviceIdentifier: exampleAwsVpclatticeService.id,
 *     serviceNetworkIdentifier: exampleAwsVpclatticeServiceNetwork.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.ServiceNetworkServiceAssociation("example",
 *     service_identifier=example_aws_vpclattice_service["id"],
 *     service_network_identifier=example_aws_vpclattice_service_network["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.ServiceNetworkServiceAssociation("example", new()
 *     {
 *         ServiceIdentifier = exampleAwsVpclatticeService.Id,
 *         ServiceNetworkIdentifier = exampleAwsVpclatticeServiceNetwork.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewServiceNetworkServiceAssociation(ctx, "example", &vpclattice.ServiceNetworkServiceAssociationArgs{
 * 			ServiceIdentifier:        pulumi.Any(exampleAwsVpclatticeService.Id),
 * 			ServiceNetworkIdentifier: pulumi.Any(exampleAwsVpclatticeServiceNetwork.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociation;
 * import com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceNetworkServiceAssociation("example", ServiceNetworkServiceAssociationArgs.builder()
 *             .serviceIdentifier(exampleAwsVpclatticeService.id())
 *             .serviceNetworkIdentifier(exampleAwsVpclatticeServiceNetwork.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:ServiceNetworkServiceAssociation
 *     properties:
 *       serviceIdentifier: ${exampleAwsVpclatticeService.id}
 *       serviceNetworkIdentifier: ${exampleAwsVpclatticeServiceNetwork.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Service Network Service Association using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/serviceNetworkServiceAssociation:ServiceNetworkServiceAssociation example snsa-05e2474658a88f6ba
 * ```
 */
public class ServiceNetworkServiceAssociation internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociation,
) : KotlinCustomResource(javaResource, ServiceNetworkServiceAssociationMapper) {
    /**
     * The ARN of the Association.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The account that created the association.
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * The custom domain name of the service.
     */
    public val customDomainName: Output<String>
        get() = javaResource.customDomainName().applyValue({ args0 -> args0 })

    /**
     * The DNS name of the service.
     */
    public val dnsEntries: Output<List<ServiceNetworkServiceAssociationDnsEntry>>
        get() = javaResource.dnsEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The ID or Amazon Resource Identifier (ARN) of the service.
     */
    public val serviceIdentifier: Output<String>
        get() = javaResource.serviceIdentifier().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
     * The following arguments are optional:
     */
    public val serviceNetworkIdentifier: Output<String>
        get() = javaResource.serviceNetworkIdentifier().applyValue({ args0 -> args0 })

    /**
     * The operations status. Valid Values are CREATE_IN_PROGRESS | ACTIVE | DELETE_IN_PROGRESS | CREATE_FAILED | DELETE_FAILED
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ServiceNetworkServiceAssociationMapper :
    ResourceMapper<ServiceNetworkServiceAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ServiceNetworkServiceAssociation =
        ServiceNetworkServiceAssociation(
            javaResource as
                com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociation,
        )
}

/**
 * @see [ServiceNetworkServiceAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceNetworkServiceAssociation].
 */
public suspend fun serviceNetworkServiceAssociation(
    name: String,
    block: suspend ServiceNetworkServiceAssociationResourceBuilder.() -> Unit,
): ServiceNetworkServiceAssociation {
    val builder = ServiceNetworkServiceAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceNetworkServiceAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceNetworkServiceAssociation(name: String): ServiceNetworkServiceAssociation {
    val builder = ServiceNetworkServiceAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
