@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Service Network VPC Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.ServiceNetworkVpcAssociation("example", {
 *     vpcIdentifier: exampleAwsVpc.id,
 *     serviceNetworkIdentifier: exampleAwsVpclatticeServiceNetwork.id,
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.ServiceNetworkVpcAssociation("example",
 *     vpc_identifier=example_aws_vpc["id"],
 *     service_network_identifier=example_aws_vpclattice_service_network["id"],
 *     security_group_ids=[example_aws_security_group["id"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.ServiceNetworkVpcAssociation("example", new()
 *     {
 *         VpcIdentifier = exampleAwsVpc.Id,
 *         ServiceNetworkIdentifier = exampleAwsVpclatticeServiceNetwork.Id,
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewServiceNetworkVpcAssociation(ctx, "example", &vpclattice.ServiceNetworkVpcAssociationArgs{
 * 			VpcIdentifier:            pulumi.Any(exampleAwsVpc.Id),
 * 			ServiceNetworkIdentifier: pulumi.Any(exampleAwsVpclatticeServiceNetwork.Id),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociation;
 * import com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceNetworkVpcAssociation("example", ServiceNetworkVpcAssociationArgs.builder()
 *             .vpcIdentifier(exampleAwsVpc.id())
 *             .serviceNetworkIdentifier(exampleAwsVpclatticeServiceNetwork.id())
 *             .securityGroupIds(exampleAwsSecurityGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:ServiceNetworkVpcAssociation
 *     properties:
 *       vpcIdentifier: ${exampleAwsVpc.id}
 *       serviceNetworkIdentifier: ${exampleAwsVpclatticeServiceNetwork.id}
 *       securityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import VPC Lattice Service Network VPC Association using the `id`. For example:
 * ```sh
 * $ pulumi import aws:vpclattice/serviceNetworkVpcAssociation:ServiceNetworkVpcAssociation example snsa-05e2474658a88f6ba
 * ```
 * @property securityGroupIds The IDs of the security groups.
 * @property serviceNetworkIdentifier The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcIdentifier The ID of the VPC.
 */
public data class ServiceNetworkVpcAssociationArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val serviceNetworkIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociationArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociationArgs =
        com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociationArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceNetworkIdentifier(serviceNetworkIdentifier?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcIdentifier(vpcIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceNetworkVpcAssociationArgs].
 */
@PulumiTagMarker
public class ServiceNetworkVpcAssociationArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var serviceNetworkIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcIdentifier: Output<String>? = null

    /**
     * @param value The IDs of the security groups.
     */
    @JvmName("lsbpvdpvfltutukc")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("uxvuhkdoufbotfme")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the security groups.
     */
    @JvmName("wcaicdkwsqyildsa")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
     * The following arguments are optional:
     */
    @JvmName("hfwfwnfwpswealvk")
    public suspend fun serviceNetworkIdentifier(`value`: Output<String>) {
        this.serviceNetworkIdentifier = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jwsjfpyyrbujkblt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("omcrffchdmpapxom")
    public suspend fun vpcIdentifier(`value`: Output<String>) {
        this.vpcIdentifier = value
    }

    /**
     * @param value The IDs of the security groups.
     */
    @JvmName("vuqhjbnyelpfpjaq")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The IDs of the security groups.
     */
    @JvmName("nkhhnixefyoxvuke")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
     * The following arguments are optional:
     */
    @JvmName("ubtllkfngsdseeug")
    public suspend fun serviceNetworkIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNetworkIdentifier = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jutmsrulrbyketey")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lngoqbtovntjhtfe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("uiutnxemtmqvxpms")
    public suspend fun vpcIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcIdentifier = mapped
    }

    internal fun build(): ServiceNetworkVpcAssociationArgs = ServiceNetworkVpcAssociationArgs(
        securityGroupIds = securityGroupIds,
        serviceNetworkIdentifier = serviceNetworkIdentifier,
        tags = tags,
        vpcIdentifier = vpcIdentifier,
    )
}
