@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.TargetGroupAttachmentTarget
import com.pulumi.aws.vpclattice.kotlin.outputs.TargetGroupAttachmentTarget.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TargetGroupAttachment].
 */
@PulumiTagMarker
public class TargetGroupAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TargetGroupAttachmentArgs = TargetGroupAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TargetGroupAttachmentArgsBuilder.() -> Unit) {
        val builder = TargetGroupAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TargetGroupAttachment {
        val builtJavaResource = com.pulumi.aws.vpclattice.TargetGroupAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TargetGroupAttachment(builtJavaResource)
    }
}

/**
 * Provides the ability to register a target with an AWS VPC Lattice Target Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.vpclattice.TargetGroupAttachment("example", {
 *     targetGroupIdentifier: exampleAwsVpclatticeTargetGroup.id,
 *     target: {
 *         id: exampleAwsLb.arn,
 *         port: 80,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.vpclattice.TargetGroupAttachment("example",
 *     target_group_identifier=example_aws_vpclattice_target_group["id"],
 *     target={
 *         "id": example_aws_lb["arn"],
 *         "port": 80,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.VpcLattice.TargetGroupAttachment("example", new()
 *     {
 *         TargetGroupIdentifier = exampleAwsVpclatticeTargetGroup.Id,
 *         Target = new Aws.VpcLattice.Inputs.TargetGroupAttachmentTargetArgs
 *         {
 *             Id = exampleAwsLb.Arn,
 *             Port = 80,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/vpclattice"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vpclattice.NewTargetGroupAttachment(ctx, "example", &vpclattice.TargetGroupAttachmentArgs{
 * 			TargetGroupIdentifier: pulumi.Any(exampleAwsVpclatticeTargetGroup.Id),
 * 			Target: &vpclattice.TargetGroupAttachmentTargetArgs{
 * 				Id:   pulumi.Any(exampleAwsLb.Arn),
 * 				Port: pulumi.Int(80),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroupAttachment;
 * import com.pulumi.aws.vpclattice.TargetGroupAttachmentArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupAttachmentTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroupAttachment("example", TargetGroupAttachmentArgs.builder()
 *             .targetGroupIdentifier(exampleAwsVpclatticeTargetGroup.id())
 *             .target(TargetGroupAttachmentTargetArgs.builder()
 *                 .id(exampleAwsLb.arn())
 *                 .port(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:vpclattice:TargetGroupAttachment
 *     properties:
 *       targetGroupIdentifier: ${exampleAwsVpclatticeTargetGroup.id}
 *       target:
 *         id: ${exampleAwsLb.arn}
 *         port: 80
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class TargetGroupAttachment internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.TargetGroupAttachment,
) : KotlinCustomResource(javaResource, TargetGroupAttachmentMapper) {
    /**
     * The target.
     */
    public val target: Output<TargetGroupAttachmentTarget>
        get() = javaResource.target().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The ID or Amazon Resource Name (ARN) of the target group.
     */
    public val targetGroupIdentifier: Output<String>
        get() = javaResource.targetGroupIdentifier().applyValue({ args0 -> args0 })
}

public object TargetGroupAttachmentMapper : ResourceMapper<TargetGroupAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.TargetGroupAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TargetGroupAttachment =
        TargetGroupAttachment(javaResource as com.pulumi.aws.vpclattice.TargetGroupAttachment)
}

/**
 * @see [TargetGroupAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TargetGroupAttachment].
 */
public suspend fun targetGroupAttachment(
    name: String,
    block: suspend TargetGroupAttachmentResourceBuilder.() -> Unit,
): TargetGroupAttachment {
    val builder = TargetGroupAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TargetGroupAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun targetGroupAttachment(name: String): TargetGroupAttachment {
    val builder = TargetGroupAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
