@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.GetResourcePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourcePolicy.
 * @property resourceArn Resource ARN of the resource for which a policy is retrieved.
 */
public data class GetResourcePolicyPlainArgs(
    public val resourceArn: String,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.GetResourcePolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.GetResourcePolicyPlainArgs =
        com.pulumi.aws.vpclattice.inputs.GetResourcePolicyPlainArgs.builder()
            .resourceArn(resourceArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourcePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetResourcePolicyPlainArgsBuilder internal constructor() {
    private var resourceArn: String? = null

    /**
     * @param value Resource ARN of the resource for which a policy is retrieved.
     */
    @JvmName("xpfbauhkdodeprdn")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceArn = mapped
    }

    internal fun build(): GetResourcePolicyPlainArgs = GetResourcePolicyPlainArgs(
        resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
    )
}
