@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fixedResponse
 * @property forwards Route requests to one or more target groups. See Forward blocks below.
 * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
 */
public data class ListenerDefaultActionArgs(
    public val fixedResponse: Output<ListenerDefaultActionFixedResponseArgs>? = null,
    public val forwards: Output<List<ListenerDefaultActionForwardArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs.builder()
            .fixedResponse(fixedResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forwards(
                forwards?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListenerDefaultActionArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionArgsBuilder internal constructor() {
    private var fixedResponse: Output<ListenerDefaultActionFixedResponseArgs>? = null

    private var forwards: Output<List<ListenerDefaultActionForwardArgs>>? = null

    /**
     * @param value
     */
    @JvmName("iyerskcvtwvdpsek")
    public suspend fun fixedResponse(`value`: Output<ListenerDefaultActionFixedResponseArgs>) {
        this.fixedResponse = value
    }

    /**
     * @param value Route requests to one or more target groups. See Forward blocks below.
     * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
     */
    @JvmName("cihdcyposopajuoe")
    public suspend fun forwards(`value`: Output<List<ListenerDefaultActionForwardArgs>>) {
        this.forwards = value
    }

    @JvmName("qcnvnfsyohtyrroy")
    public suspend fun forwards(vararg values: Output<ListenerDefaultActionForwardArgs>) {
        this.forwards = Output.all(values.asList())
    }

    /**
     * @param values Route requests to one or more target groups. See Forward blocks below.
     * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
     */
    @JvmName("tqibekikihawrorf")
    public suspend fun forwards(values: List<Output<ListenerDefaultActionForwardArgs>>) {
        this.forwards = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kpknagaetdpdvtsu")
    public suspend fun fixedResponse(`value`: ListenerDefaultActionFixedResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedResponse = mapped
    }

    /**
     * @param argument
     */
    @JvmName("volamjxdrqpeoheh")
    public suspend fun fixedResponse(argument: suspend ListenerDefaultActionFixedResponseArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionFixedResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fixedResponse = mapped
    }

    /**
     * @param value Route requests to one or more target groups. See Forward blocks below.
     * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
     */
    @JvmName("vmoqvrsjwmulyssj")
    public suspend fun forwards(`value`: List<ListenerDefaultActionForwardArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwards = mapped
    }

    /**
     * @param argument Route requests to one or more target groups. See Forward blocks below.
     * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
     */
    @JvmName("galpiqtqvpkslsbs")
    public suspend fun forwards(argument: List<suspend ListenerDefaultActionForwardArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.forwards = mapped
    }

    /**
     * @param argument Route requests to one or more target groups. See Forward blocks below.
     * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
     */
    @JvmName("yggrnrfcosfarxwq")
    public suspend fun forwards(vararg argument: suspend ListenerDefaultActionForwardArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.forwards = mapped
    }

    /**
     * @param argument Route requests to one or more target groups. See Forward blocks below.
     * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
     */
    @JvmName("dlpgcmnduosiqgyw")
    public suspend fun forwards(argument: suspend ListenerDefaultActionForwardArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerDefaultActionForwardArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.forwards = mapped
    }

    /**
     * @param values Route requests to one or more target groups. See Forward blocks below.
     * > **NOTE:** You must specify exactly one of the following argument blocks: `fixed_response` or `forward`.
     */
    @JvmName("mpslwhomchcdsqst")
    public suspend fun forwards(vararg values: ListenerDefaultActionForwardArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwards = mapped
    }

    internal fun build(): ListenerDefaultActionArgs = ListenerDefaultActionArgs(
        fixedResponse = fixedResponse,
        forwards = forwards,
    )
}
