@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardTargetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property targetGroupIdentifier ID or Amazon Resource Name (ARN) of the target group.
 * @property weight Determines how requests are distributed to the target group. Only required if you specify multiple target groups for a forward action. For example, if you specify two target groups, one with a
 * weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. See [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the AWS documentation for additional examples. Default: `100`.
 */
public data class ListenerDefaultActionForwardTargetGroupArgs(
    public val targetGroupIdentifier: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardTargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardTargetGroupArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardTargetGroupArgs.builder()
            .targetGroupIdentifier(targetGroupIdentifier?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionForwardTargetGroupArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionForwardTargetGroupArgsBuilder internal constructor() {
    private var targetGroupIdentifier: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value ID or Amazon Resource Name (ARN) of the target group.
     */
    @JvmName("ylinvvfdekafghhp")
    public suspend fun targetGroupIdentifier(`value`: Output<String>) {
        this.targetGroupIdentifier = value
    }

    /**
     * @param value Determines how requests are distributed to the target group. Only required if you specify multiple target groups for a forward action. For example, if you specify two target groups, one with a
     * weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. See [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the AWS documentation for additional examples. Default: `100`.
     */
    @JvmName("ktjkyppstbnegkbm")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value ID or Amazon Resource Name (ARN) of the target group.
     */
    @JvmName("ytuqnclnvfqmchvw")
    public suspend fun targetGroupIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupIdentifier = mapped
    }

    /**
     * @param value Determines how requests are distributed to the target group. Only required if you specify multiple target groups for a forward action. For example, if you specify two target groups, one with a
     * weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. See [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the AWS documentation for additional examples. Default: `100`.
     */
    @JvmName("uwjekonjfdovswqp")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ListenerDefaultActionForwardTargetGroupArgs =
        ListenerDefaultActionForwardTargetGroupArgs(
            targetGroupIdentifier = targetGroupIdentifier,
            weight = weight,
        )
}
