@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fixedResponse Describes the rule action that returns a custom HTTP response.
 * @property forward The forward action. Traffic that matches the rule is forwarded to the specified target groups.
 */
public data class ListenerRuleActionArgs(
    public val fixedResponse: Output<ListenerRuleActionFixedResponseArgs>? = null,
    public val forward: Output<ListenerRuleActionForwardArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs.builder()
            .fixedResponse(fixedResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forward(forward?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ListenerRuleActionArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionArgsBuilder internal constructor() {
    private var fixedResponse: Output<ListenerRuleActionFixedResponseArgs>? = null

    private var forward: Output<ListenerRuleActionForwardArgs>? = null

    /**
     * @param value Describes the rule action that returns a custom HTTP response.
     */
    @JvmName("vlpdekyjmicgqrrr")
    public suspend fun fixedResponse(`value`: Output<ListenerRuleActionFixedResponseArgs>) {
        this.fixedResponse = value
    }

    /**
     * @param value The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     */
    @JvmName("exbatenksgkwarex")
    public suspend fun forward(`value`: Output<ListenerRuleActionForwardArgs>) {
        this.forward = value
    }

    /**
     * @param value Describes the rule action that returns a custom HTTP response.
     */
    @JvmName("egibnkpcbpkedigf")
    public suspend fun fixedResponse(`value`: ListenerRuleActionFixedResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedResponse = mapped
    }

    /**
     * @param argument Describes the rule action that returns a custom HTTP response.
     */
    @JvmName("gcirmyktdudeftki")
    public suspend fun fixedResponse(argument: suspend ListenerRuleActionFixedResponseArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionFixedResponseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fixedResponse = mapped
    }

    /**
     * @param value The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     */
    @JvmName("eogdyacebhaupxjq")
    public suspend fun forward(`value`: ListenerRuleActionForwardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forward = mapped
    }

    /**
     * @param argument The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     */
    @JvmName("vqspfqdditkrmaqd")
    public suspend fun forward(argument: suspend ListenerRuleActionForwardArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionForwardArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.forward = mapped
    }

    internal fun build(): ListenerRuleActionArgs = ListenerRuleActionArgs(
        fixedResponse = fixedResponse,
        forward = forward,
    )
}
