@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property httpMatch The HTTP criteria that a rule must match.
 */
public data class ListenerRuleMatchArgs(
    public val httpMatch: Output<ListenerRuleMatchHttpMatchArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs.builder()
            .httpMatch(httpMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ListenerRuleMatchArgs].
 */
@PulumiTagMarker
public class ListenerRuleMatchArgsBuilder internal constructor() {
    private var httpMatch: Output<ListenerRuleMatchHttpMatchArgs>? = null

    /**
     * @param value The HTTP criteria that a rule must match.
     */
    @JvmName("lvblsxqbycgxoeif")
    public suspend fun httpMatch(`value`: Output<ListenerRuleMatchHttpMatchArgs>) {
        this.httpMatch = value
    }

    /**
     * @param value The HTTP criteria that a rule must match.
     */
    @JvmName("dyohrgdthymuwria")
    public suspend fun httpMatch(`value`: ListenerRuleMatchHttpMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMatch = mapped
    }

    /**
     * @param argument The HTTP criteria that a rule must match.
     */
    @JvmName("xawuskwtfckbmyuh")
    public suspend fun httpMatch(argument: suspend ListenerRuleMatchHttpMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleMatchHttpMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpMatch = mapped
    }

    internal fun build(): ListenerRuleMatchArgs = ListenerRuleMatchArgs(
        httpMatch = httpMatch,
    )
}
