@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property headerMatches The header matches. Matches incoming requests with rule based on request header value before applying rule action.
 * @property method The HTTP method type.
 * @property pathMatch The path match.
 */
public data class ListenerRuleMatchHttpMatchArgs(
    public val headerMatches: Output<List<ListenerRuleMatchHttpMatchHeaderMatchArgs>>? = null,
    public val method: Output<String>? = null,
    public val pathMatch: Output<ListenerRuleMatchHttpMatchPathMatchArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs.builder()
            .headerMatches(
                headerMatches?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .method(method?.applyValue({ args0 -> args0 }))
            .pathMatch(pathMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ListenerRuleMatchHttpMatchArgs].
 */
@PulumiTagMarker
public class ListenerRuleMatchHttpMatchArgsBuilder internal constructor() {
    private var headerMatches: Output<List<ListenerRuleMatchHttpMatchHeaderMatchArgs>>? = null

    private var method: Output<String>? = null

    private var pathMatch: Output<ListenerRuleMatchHttpMatchPathMatchArgs>? = null

    /**
     * @param value The header matches. Matches incoming requests with rule based on request header value before applying rule action.
     */
    @JvmName("yvsckjmqvbwwtuua")
    public suspend fun headerMatches(`value`: Output<List<ListenerRuleMatchHttpMatchHeaderMatchArgs>>) {
        this.headerMatches = value
    }

    @JvmName("kylvolmjgpsdgumc")
    public suspend fun headerMatches(vararg values: Output<ListenerRuleMatchHttpMatchHeaderMatchArgs>) {
        this.headerMatches = Output.all(values.asList())
    }

    /**
     * @param values The header matches. Matches incoming requests with rule based on request header value before applying rule action.
     */
    @JvmName("yqtjhquwlqkfagcu")
    public suspend fun headerMatches(values: List<Output<ListenerRuleMatchHttpMatchHeaderMatchArgs>>) {
        this.headerMatches = Output.all(values)
    }

    /**
     * @param value The HTTP method type.
     */
    @JvmName("pkrjcvggmnjlyuns")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value The path match.
     */
    @JvmName("vielrapxrkwjlyiw")
    public suspend fun pathMatch(`value`: Output<ListenerRuleMatchHttpMatchPathMatchArgs>) {
        this.pathMatch = value
    }

    /**
     * @param value The header matches. Matches incoming requests with rule based on request header value before applying rule action.
     */
    @JvmName("ftershuflubkfrev")
    public suspend fun headerMatches(`value`: List<ListenerRuleMatchHttpMatchHeaderMatchArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerMatches = mapped
    }

    /**
     * @param argument The header matches. Matches incoming requests with rule based on request header value before applying rule action.
     */
    @JvmName("dqslitqkqehoxvly")
    public suspend fun headerMatches(argument: List<suspend ListenerRuleMatchHttpMatchHeaderMatchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerRuleMatchHttpMatchHeaderMatchArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headerMatches = mapped
    }

    /**
     * @param argument The header matches. Matches incoming requests with rule based on request header value before applying rule action.
     */
    @JvmName("jdkiyylduubiavje")
    public suspend fun headerMatches(vararg argument: suspend ListenerRuleMatchHttpMatchHeaderMatchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerRuleMatchHttpMatchHeaderMatchArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headerMatches = mapped
    }

    /**
     * @param argument The header matches. Matches incoming requests with rule based on request header value before applying rule action.
     */
    @JvmName("ceosqnkdusvwwhcv")
    public suspend fun headerMatches(argument: suspend ListenerRuleMatchHttpMatchHeaderMatchArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerRuleMatchHttpMatchHeaderMatchArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.headerMatches = mapped
    }

    /**
     * @param values The header matches. Matches incoming requests with rule based on request header value before applying rule action.
     */
    @JvmName("cthgicprawjebvpu")
    public suspend fun headerMatches(vararg values: ListenerRuleMatchHttpMatchHeaderMatchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerMatches = mapped
    }

    /**
     * @param value The HTTP method type.
     */
    @JvmName("ekqgrmfnhyvwerwy")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The path match.
     */
    @JvmName("jetqekxsempeyivq")
    public suspend fun pathMatch(`value`: ListenerRuleMatchHttpMatchPathMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathMatch = mapped
    }

    /**
     * @param argument The path match.
     */
    @JvmName("dbidlnefgkrjiorr")
    public suspend fun pathMatch(argument: suspend ListenerRuleMatchHttpMatchPathMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleMatchHttpMatchPathMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.pathMatch = mapped
    }

    internal fun build(): ListenerRuleMatchHttpMatchArgs = ListenerRuleMatchHttpMatchArgs(
        headerMatches = headerMatches,
        method = method,
        pathMatch = pathMatch,
    )
}
