@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property caseSensitive Indicates whether the match is case sensitive. Defaults to false.
 * @property match The header match type.
 * @property name The name of the header.
 */
public data class ListenerRuleMatchHttpMatchHeaderMatchArgs(
    public val caseSensitive: Output<Boolean>? = null,
    public val match: Output<ListenerRuleMatchHttpMatchHeaderMatchMatchArgs>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchArgs = com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchArgs.builder()
        .caseSensitive(caseSensitive?.applyValue({ args0 -> args0 }))
        .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleMatchHttpMatchHeaderMatchArgs].
 */
@PulumiTagMarker
public class ListenerRuleMatchHttpMatchHeaderMatchArgsBuilder internal constructor() {
    private var caseSensitive: Output<Boolean>? = null

    private var match: Output<ListenerRuleMatchHttpMatchHeaderMatchMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Indicates whether the match is case sensitive. Defaults to false.
     */
    @JvmName("flgalbrbiimfpvjm")
    public suspend fun caseSensitive(`value`: Output<Boolean>) {
        this.caseSensitive = value
    }

    /**
     * @param value The header match type.
     */
    @JvmName("ndxkhfxxfrdigkpo")
    public suspend fun match(`value`: Output<ListenerRuleMatchHttpMatchHeaderMatchMatchArgs>) {
        this.match = value
    }

    /**
     * @param value The name of the header.
     */
    @JvmName("gwxawkikjmovcinl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether the match is case sensitive. Defaults to false.
     */
    @JvmName("fhovjywityrwnoxj")
    public suspend fun caseSensitive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caseSensitive = mapped
    }

    /**
     * @param value The header match type.
     */
    @JvmName("ttugpjgbfaycypsb")
    public suspend fun match(`value`: ListenerRuleMatchHttpMatchHeaderMatchMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument The header match type.
     */
    @JvmName("iwqqycpiaxbhqwoc")
    public suspend fun match(argument: suspend ListenerRuleMatchHttpMatchHeaderMatchMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleMatchHttpMatchHeaderMatchMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value The name of the header.
     */
    @JvmName("vbueeiagsxnsdmcf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ListenerRuleMatchHttpMatchHeaderMatchArgs =
        ListenerRuleMatchHttpMatchHeaderMatchArgs(
            caseSensitive = caseSensitive,
            match = match ?: throw PulumiNullFieldException("match"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
