@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property caseSensitive Indicates whether the match is case sensitive. Defaults to false.
 * @property match The header match type.
 */
public data class ListenerRuleMatchHttpMatchPathMatchArgs(
    public val caseSensitive: Output<Boolean>? = null,
    public val match: Output<ListenerRuleMatchHttpMatchPathMatchMatchArgs>,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs.builder()
            .caseSensitive(caseSensitive?.applyValue({ args0 -> args0 }))
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ListenerRuleMatchHttpMatchPathMatchArgs].
 */
@PulumiTagMarker
public class ListenerRuleMatchHttpMatchPathMatchArgsBuilder internal constructor() {
    private var caseSensitive: Output<Boolean>? = null

    private var match: Output<ListenerRuleMatchHttpMatchPathMatchMatchArgs>? = null

    /**
     * @param value Indicates whether the match is case sensitive. Defaults to false.
     */
    @JvmName("gnnldgcjeedijhyy")
    public suspend fun caseSensitive(`value`: Output<Boolean>) {
        this.caseSensitive = value
    }

    /**
     * @param value The header match type.
     */
    @JvmName("ncycctjejdegwopy")
    public suspend fun match(`value`: Output<ListenerRuleMatchHttpMatchPathMatchMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Indicates whether the match is case sensitive. Defaults to false.
     */
    @JvmName("afkpnxtsekivgcsk")
    public suspend fun caseSensitive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caseSensitive = mapped
    }

    /**
     * @param value The header match type.
     */
    @JvmName("rajgufiiwticsvpm")
    public suspend fun match(`value`: ListenerRuleMatchHttpMatchPathMatchMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument The header match type.
     */
    @JvmName("pvrlykticdwdbenn")
    public suspend fun match(argument: suspend ListenerRuleMatchHttpMatchPathMatchMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleMatchHttpMatchPathMatchMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    internal fun build(): ListenerRuleMatchHttpMatchPathMatchArgs =
        ListenerRuleMatchHttpMatchPathMatchArgs(
            caseSensitive = caseSensitive,
            match = match ?: throw PulumiNullFieldException("match"),
        )
}
