@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.TargetGroupAttachmentTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ID of the target. If the target type of the target group is INSTANCE, this is an instance ID. If the target type is IP , this is an IP address. If the target type is LAMBDA, this is the ARN of the Lambda function. If the target type is ALB, this is the ARN of the Application Load Balancer.
 * @property port This port is used for routing traffic to the target, and defaults to the target group port. However, you can override the default and specify a custom port.
 */
public data class TargetGroupAttachmentTargetArgs(
    public val id: Output<String>,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.TargetGroupAttachmentTargetArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.TargetGroupAttachmentTargetArgs =
        com.pulumi.aws.vpclattice.inputs.TargetGroupAttachmentTargetArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupAttachmentTargetArgs].
 */
@PulumiTagMarker
public class TargetGroupAttachmentTargetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The ID of the target. If the target type of the target group is INSTANCE, this is an instance ID. If the target type is IP , this is an IP address. If the target type is LAMBDA, this is the ARN of the Lambda function. If the target type is ALB, this is the ARN of the Application Load Balancer.
     */
    @JvmName("goepuwtvjnqefcgs")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value This port is used for routing traffic to the target, and defaults to the target group port. However, you can override the default and specify a custom port.
     */
    @JvmName("fpoyyltgccwtomdq")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ID of the target. If the target type of the target group is INSTANCE, this is an instance ID. If the target type is IP , this is an IP address. If the target type is LAMBDA, this is the ARN of the Lambda function. If the target type is ALB, this is the ARN of the Application Load Balancer.
     */
    @JvmName("pgqaewgysytqqvvc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value This port is used for routing traffic to the target, and defaults to the target group port. However, you can override the default and specify a custom port.
     */
    @JvmName("xymmeuryttomrecg")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): TargetGroupAttachmentTargetArgs = TargetGroupAttachmentTargetArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        port = port,
    )
}
