@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Indicates whether health checking is enabled. Defaults to `true`.
 * @property healthCheckIntervalSeconds The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
 * @property healthCheckTimeoutSeconds The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
 * * `healthy_threshold_count ` - (Optional) The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
 * @property healthyThresholdCount
 * @property matcher The codes to use when checking for a successful response from a target. These are called _Success codes_ in the console.
 * @property path The destination for health checks on the targets. If the protocol version is HTTP/1.1 or HTTP/2, specify a valid URI (for example, /path?query). The default path is `/`. Health checks are not supported if the protocol version is gRPC, however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
 * @property port The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
 * @property protocol The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`.
 * @property protocolVersion The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`. The default is `HTTP1`.
 * @property unhealthyThresholdCount The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
 */
public data class TargetGroupConfigHealthCheckArgs(
    public val enabled: Output<Boolean>? = null,
    public val healthCheckIntervalSeconds: Output<Int>? = null,
    public val healthCheckTimeoutSeconds: Output<Int>? = null,
    public val healthyThresholdCount: Output<Int>? = null,
    public val matcher: Output<TargetGroupConfigHealthCheckMatcherArgs>? = null,
    public val path: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val protocolVersion: Output<String>? = null,
    public val unhealthyThresholdCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckArgs =
        com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .healthCheckIntervalSeconds(healthCheckIntervalSeconds?.applyValue({ args0 -> args0 }))
            .healthCheckTimeoutSeconds(healthCheckTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .healthyThresholdCount(healthyThresholdCount?.applyValue({ args0 -> args0 }))
            .matcher(matcher?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .protocolVersion(protocolVersion?.applyValue({ args0 -> args0 }))
            .unhealthyThresholdCount(unhealthyThresholdCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupConfigHealthCheckArgs].
 */
@PulumiTagMarker
public class TargetGroupConfigHealthCheckArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var healthCheckIntervalSeconds: Output<Int>? = null

    private var healthCheckTimeoutSeconds: Output<Int>? = null

    private var healthyThresholdCount: Output<Int>? = null

    private var matcher: Output<TargetGroupConfigHealthCheckMatcherArgs>? = null

    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var protocolVersion: Output<String>? = null

    private var unhealthyThresholdCount: Output<Int>? = null

    /**
     * @param value Indicates whether health checking is enabled. Defaults to `true`.
     */
    @JvmName("kosupdujbbxfxpky")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
     */
    @JvmName("bbqaqrtdydqmtsbf")
    public suspend fun healthCheckIntervalSeconds(`value`: Output<Int>) {
        this.healthCheckIntervalSeconds = value
    }

    /**
     * @param value The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
     * * `healthy_threshold_count ` - (Optional) The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
     */
    @JvmName("syiubxolqfoerxta")
    public suspend fun healthCheckTimeoutSeconds(`value`: Output<Int>) {
        this.healthCheckTimeoutSeconds = value
    }

    /**
     * @param value
     */
    @JvmName("cebxfeylryhlapeo")
    public suspend fun healthyThresholdCount(`value`: Output<Int>) {
        this.healthyThresholdCount = value
    }

    /**
     * @param value The codes to use when checking for a successful response from a target. These are called _Success codes_ in the console.
     */
    @JvmName("xwcfsatufnnmyvws")
    public suspend fun matcher(`value`: Output<TargetGroupConfigHealthCheckMatcherArgs>) {
        this.matcher = value
    }

    /**
     * @param value The destination for health checks on the targets. If the protocol version is HTTP/1.1 or HTTP/2, specify a valid URI (for example, /path?query). The default path is `/`. Health checks are not supported if the protocol version is gRPC, however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
     */
    @JvmName("hqrcbstjjodqbscl")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
     */
    @JvmName("llciqodcndwoftvi")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`.
     */
    @JvmName("ukwtxgudpoflqdnq")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`. The default is `HTTP1`.
     */
    @JvmName("jkispxckyblwvnfb")
    public suspend fun protocolVersion(`value`: Output<String>) {
        this.protocolVersion = value
    }

    /**
     * @param value The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
     */
    @JvmName("xkcpunjjbcxrsewj")
    public suspend fun unhealthyThresholdCount(`value`: Output<Int>) {
        this.unhealthyThresholdCount = value
    }

    /**
     * @param value Indicates whether health checking is enabled. Defaults to `true`.
     */
    @JvmName("rhkqimttmovkuuhr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
     */
    @JvmName("gjsgtmfhceiciimt")
    public suspend fun healthCheckIntervalSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckIntervalSeconds = mapped
    }

    /**
     * @param value The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
     * * `healthy_threshold_count ` - (Optional) The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
     */
    @JvmName("amnfynaykiyxsqnp")
    public suspend fun healthCheckTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTimeoutSeconds = mapped
    }

    /**
     * @param value
     */
    @JvmName("eqbsihjkxchibixj")
    public suspend fun healthyThresholdCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThresholdCount = mapped
    }

    /**
     * @param value The codes to use when checking for a successful response from a target. These are called _Success codes_ in the console.
     */
    @JvmName("icahwddsjphwegek")
    public suspend fun matcher(`value`: TargetGroupConfigHealthCheckMatcherArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matcher = mapped
    }

    /**
     * @param argument The codes to use when checking for a successful response from a target. These are called _Success codes_ in the console.
     */
    @JvmName("jxujetqwncchfhaf")
    public suspend fun matcher(argument: suspend TargetGroupConfigHealthCheckMatcherArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupConfigHealthCheckMatcherArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.matcher = mapped
    }

    /**
     * @param value The destination for health checks on the targets. If the protocol version is HTTP/1.1 or HTTP/2, specify a valid URI (for example, /path?query). The default path is `/`. Health checks are not supported if the protocol version is gRPC, however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
     */
    @JvmName("gwtworhhpfnrduhs")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
     */
    @JvmName("eykbcfwbpnjnwgwj")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`.
     */
    @JvmName("ppobiutousbqnynl")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`. The default is `HTTP1`.
     */
    @JvmName("xcoejpktyolyjyld")
    public suspend fun protocolVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolVersion = mapped
    }

    /**
     * @param value The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
     */
    @JvmName("xwwqmkxuirghxgce")
    public suspend fun unhealthyThresholdCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThresholdCount = mapped
    }

    internal fun build(): TargetGroupConfigHealthCheckArgs = TargetGroupConfigHealthCheckArgs(
        enabled = enabled,
        healthCheckIntervalSeconds = healthCheckIntervalSeconds,
        healthCheckTimeoutSeconds = healthCheckTimeoutSeconds,
        healthyThresholdCount = healthyThresholdCount,
        matcher = matcher,
        path = path,
        port = port,
        protocol = protocol,
        protocolVersion = protocolVersion,
        unhealthyThresholdCount = unhealthyThresholdCount,
    )
}
