@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAuthPolicy.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property policy The auth policy. The policy string in JSON must not contain newlines or blank lines.
 * @property resourceIdentifier
 * @property state The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
 */
public data class GetAuthPolicyResult(
    public val id: String,
    public val policy: String? = null,
    public val resourceIdentifier: String,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.GetAuthPolicyResult): GetAuthPolicyResult = GetAuthPolicyResult(
            id = javaType.id(),
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            resourceIdentifier = javaType.resourceIdentifier(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
