@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getService.
 * @property arn ARN of the service.
 * @property authType Type of IAM policy. Either `NONE` or `AWS_IAM`.
 * @property certificateArn Amazon Resource Name (ARN) of the certificate.
 * @property customDomainName Custom domain name of the service.
 * @property dnsEntries DNS name of the service.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property serviceIdentifier
 * @property status Status of the service.
 * @property tags List of tags associated with the service.
 */
public data class GetServiceResult(
    public val arn: String,
    public val authType: String,
    public val certificateArn: String,
    public val customDomainName: String,
    public val dnsEntries: List<GetServiceDnsEntry>,
    public val id: String,
    public val name: String,
    public val serviceIdentifier: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            arn = javaType.arn(),
            authType = javaType.authType(),
            certificateArn = javaType.certificateArn(),
            customDomainName = javaType.customDomainName(),
            dnsEntries = javaType.dnsEntries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.GetServiceDnsEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            serviceIdentifier = javaType.serviceIdentifier(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
