@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property fixedResponse Describes the rule action that returns a custom HTTP response.
 * @property forward The forward action. Traffic that matches the rule is forwarded to the specified target groups.
 */
public data class ListenerRuleAction(
    public val fixedResponse: ListenerRuleActionFixedResponse? = null,
    public val forward: ListenerRuleActionForward? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.ListenerRuleAction): ListenerRuleAction = ListenerRuleAction(
            fixedResponse = javaType.fixedResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleActionFixedResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forward = javaType.forward().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleActionForward.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
