@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property targetGroups The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
 * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
 */
public data class ListenerRuleActionForward(
    public val targetGroups: List<ListenerRuleActionForwardTargetGroup>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.ListenerRuleActionForward): ListenerRuleActionForward = ListenerRuleActionForward(
            targetGroups = javaType.targetGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleActionForwardTargetGroup.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
