@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headerMatches The header matches. Matches incoming requests with rule based on request header value before applying rule action.
 * @property method The HTTP method type.
 * @property pathMatch The path match.
 */
public data class ListenerRuleMatchHttpMatch(
    public val headerMatches: List<ListenerRuleMatchHttpMatchHeaderMatch>? = null,
    public val method: String? = null,
    public val pathMatch: ListenerRuleMatchHttpMatchPathMatch? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.ListenerRuleMatchHttpMatch): ListenerRuleMatchHttpMatch = ListenerRuleMatchHttpMatch(
            headerMatches = javaType.headerMatches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleMatchHttpMatchHeaderMatch.Companion.toKotlin(args0)
                })
            }),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            pathMatch = javaType.pathMatch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleMatchHttpMatchPathMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
