@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property caseSensitive Indicates whether the match is case sensitive. Defaults to false.
 * @property match The header match type.
 * @property name The name of the header.
 */
public data class ListenerRuleMatchHttpMatchHeaderMatch(
    public val caseSensitive: Boolean? = null,
    public val match: ListenerRuleMatchHttpMatchHeaderMatchMatch,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.ListenerRuleMatchHttpMatchHeaderMatch): ListenerRuleMatchHttpMatchHeaderMatch = ListenerRuleMatchHttpMatchHeaderMatch(
            caseSensitive = javaType.caseSensitive().map({ args0 -> args0 }).orElse(null),
            match = javaType.match().let({ args0 ->
                com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleMatchHttpMatchHeaderMatchMatch.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
        )
    }
}
