@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property healthCheck The health check configuration.
 * @property ipAddressType The type of IP address used for the target group. Valid values: `IPV4` | `IPV6`.
 * @property lambdaEventStructureVersion The version of the event structure that the Lambda function receives. Supported only if `type` is `LAMBDA`. Valid Values are `V1` | `V2`.
 * @property port The port on which the targets are listening.
 * @property protocol The protocol to use for routing traffic to the targets. Valid Values are `HTTP` | `HTTPS`.
 * @property protocolVersion The protocol version. Valid Values are `HTTP1` | `HTTP2` | `GRPC`. Default value is `HTTP1`.
 * @property vpcIdentifier The ID of the VPC.
 */
public data class TargetGroupConfig(
    public val healthCheck: TargetGroupConfigHealthCheck? = null,
    public val ipAddressType: String? = null,
    public val lambdaEventStructureVersion: String? = null,
    public val port: Int? = null,
    public val protocol: String? = null,
    public val protocolVersion: String? = null,
    public val vpcIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.TargetGroupConfig): TargetGroupConfig = TargetGroupConfig(
            healthCheck = javaType.healthCheck().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.TargetGroupConfigHealthCheck.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipAddressType = javaType.ipAddressType().map({ args0 -> args0 }).orElse(null),
            lambdaEventStructureVersion = javaType.lambdaEventStructureVersion().map({ args0 ->
                args0
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            protocolVersion = javaType.protocolVersion().map({ args0 -> args0 }).orElse(null),
            vpcIdentifier = javaType.vpcIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
